% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-both-regression.R
\name{ols_step_both_sbic}
\alias{ols_step_both_sbic}
\alias{ols_step_both_sbic.default}
\alias{plot.ols_step_both_sbic}
\title{Stepwise SBIC regression}
\usage{
ols_step_both_sbic(model, ...)

\method{ols_step_both_sbic}{default}(
  model,
  include = NULL,
  exclude = NULL,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_both_sbic}(x, print_plot = TRUE, details = TRUE, digits = 3, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other arguments.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, details of variable selection will
be printed on screen.}

\item{x}{An object of class \code{ols_step_both_*}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{digits}{Number of decimal places to display.}
}
\value{
List containing the following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
\item{others}{list; info used for plotting and printing}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on sawa bayesian criterion, in a
stepwise manner until there is no variable left to enter or remove any more.
}
\examples{
\dontrun{
# stepwise regression
model <- lm(y ~ ., data = stepdata)
ols_step_both_sbic(model)

# stepwise regression plot
model <- lm(y ~ ., data = stepdata)
k <- ols_step_both_sbic(model)
plot(k)

# selection metrics
k$metrics

# final model
k$model

# include or exclude variables
# force variable to be included in selection process
model <- lm(y ~ ., data = stepdata)

ols_step_both_sbic(model, include = c("x6"))

# use index of variable instead of name
ols_step_both_sbic(model, include = c(6))

# force variable to be excluded from selection process
ols_step_both_sbic(model, exclude = c("x2"))

# use index of variable instead of name
ols_step_both_sbic(model, exclude = c(2))

# include & exclude variables in the selection process
ols_step_both_sbic(model, include = c("x6"), exclude = c("x2"))

# use index of variable instead of name
ols_step_both_sbic(model, include = c(6), exclude = c(2))
}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other both direction selection procedures: 
\code{\link{ols_step_both_adj_r2}()},
\code{\link{ols_step_both_aic}()},
\code{\link{ols_step_both_r2}()},
\code{\link{ols_step_both_sbc}()}
}
\concept{both direction selection procedures}
