% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_sbc}
\alias{ols_sbc}
\title{Bayesian information criterion}
\usage{
ols_sbc(model, method = c("R", "STATA", "SAS"))
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{method}{A character vector; specify the method to compute BIC. Valid
options include R, STATA and SAS.}
}
\value{
The bayesian information criterion of the model.
}
\description{
Bayesian information criterion for model selection.
}
\details{
SBC provides a means for model selection. Given a collection of models for
the data, SBC estimates the quality of each model, relative to each of the
other models. R and STATA use loglikelihood to compute SBC. SAS uses residual
sum of squares. Below is the formula in each case:

\emph{R & STATA}
\deqn{AIC = -2(loglikelihood) + ln(n) * 2p}

\emph{SAS}
\deqn{AIC = n * ln(SSE / n) + p * ln(n)}

where \emph{n} is the sample size and \emph{p} is the number of model parameters including intercept.
}
\examples{
# using R computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_sbc(model)

# using STATA computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_sbc(model, method = 'STATA')

# using SAS computation method
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_sbc(model, method = 'SAS')

}
\references{
Schwarz, G. (1978). “Estimating the Dimension of a Model.” Annals of Statistics 6:461–464.

Judge, G. G., Griffiths, W. E., Hill, R. C., and Lee, T.-C. (1980). The Theory and Practice of Econometrics.
New York: John Wiley & Sons.
}
\seealso{
Other model selection criteria: \code{\link{ols_aic}},
  \code{\link{ols_apc}}, \code{\link{ols_fpe}},
  \code{\link{ols_hsp}}, \code{\link{ols_mallows_cp}},
  \code{\link{ols_msep}}, \code{\link{ols_sbic}}
}
\concept{model selection criteria}
