% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-regression.R
\name{ols_step_both_p}
\alias{ols_step_both_p}
\alias{ols_step_both_p.default}
\alias{plot.ols_step_both_p}
\alias{ols_stepwise}
\title{Stepwise regression}
\usage{
ols_step_both_p(model, ...)

\method{ols_step_both_p}{default}(model, pent = 0.1, prem = 0.3,
  details = FALSE, ...)

\method{plot}{ols_step_both_p}(x, model = NA, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{pent}{p value; variables with p value less than \code{pent} will enter
into the model.}

\item{prem}{p value; variables with p more than \code{prem} will be removed
from the model.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_both_p}.}
}
\value{
\code{ols_step_both_p} returns an object of class \code{"ols_step_both_p"}.
An object of class \code{"ols_step_both_p"} is a list containing the
following components:

\item{orders}{candidate predictor variables according to the order by which they were added or removed from the model}
\item{method}{addition/deletion}
\item{steps}{total number of steps}
\item{predictors}{variables retained in the model (after addition)}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on p values, in a stepwise manner
until there is no variable left to enter or remove any more.
}
\section{Deprecated Function}{

\code{ols_stepwise()} has been deprecated. Instead use \code{ols_step_both_p()}.
}

\examples{
\dontrun{
# stepwise regression
model <- lm(y ~ ., data = surgical)
ols_step_both_p(model)
}

\dontrun{
# stepwise regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_both_p(model)
plot(k)
}

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
