% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-backward-regression.R
\name{ols_step_backward}
\alias{ols_step_backward}
\alias{ols_step_backward.default}
\alias{plot.ols_step_backward}
\title{Stepwise Backward Regression}
\usage{
ols_step_backward(model, ...)

\method{ols_step_backward}{default}(model, prem = 0.3, details = FALSE, ...)

\method{plot}{ols_step_backward}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}; the model should include all candidate predictor variables}

\item{...}{other inputs}

\item{prem}{p value; variables with p more than \code{prem} will be removed from the model}

\item{details}{logical; if \code{TRUE}, will print the regression result at each step}

\item{x}{an object of class \code{ols_step_backward}}
}
\value{
\code{ols_step_backward} returns an object of class \code{"ols_step_backward"}.
An object of class \code{"ols_step_backward"} is a list containing the
following components:

\item{steps}{total number of steps}
\item{removed}{variables removed from the model}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by removing predictors based on 
p values, in a stepwise manner until there is no variable left to remove any more.
}
\examples{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_step_backward(model)

# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_backward(model)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
