% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-studentized-residual-plot.R
\name{ols_srsd_plot}
\alias{ols_srsd_plot}
\title{Studentized Residual Plot}
\usage{
ols_srsd_plot(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\description{
Graph for identifying outliers
}
\details{
Studentized deleted residuals (or externally studentized residuals) is the deleted residual 
divided by its estimated standard deviation. Studentized residuals are going to be more effective for 
detecting outlying Y observations than standardized residuals. If an observation has an externally 
studentized residual that is larger than 3 (in absolute value) we can call it an outlier.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_srsd_plot(model)
}

