% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{resp_process}
\alias{resp_process}
\title{Process httr2 response object}
\usage{
resp_process(resp, output = c("df", "jsonlist", "raw", "resp", "text"))
}
\arguments{
\item{resp}{A httr2 response object.}

\item{output}{The output format. Default is "df". Other options are "jsonlist", "raw", "resp" (httr2 response object), "text"}
}
\value{
A data frame, json list, raw or httr2 response object.
}
\description{
Process httr2 response object
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
resp <- list_models("resp")
resp_process(resp, "df") # parse response to dataframe/tibble
resp_process(resp, "jsonlist") # parse response to list
resp_process(resp, "raw") # parse response to raw string
resp_process(resp, "resp") # return input response object
resp_process(resp, "text") # return text/character vector
\dontshow{\}) # examplesIf}
}
