% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm_offset}
\alias{glm_offset}
\title{Fit Generalized Linear Models with an Offset}
\usage{
glm_offset(
  formula,
  family = "gaussian",
  data,
  offset_col = "offset",
  weights = NULL
)
}
\arguments{
\item{formula}{A model formula}

\item{family}{A function or character string describing the link function
and error distribution.}

\item{data}{Optional. A data frame containing variables used in the model.}

\item{offset_col}{Character string. The name of a column in \code{data} containing
offsets.}

\item{weights}{Optional weights to use in the fitting process.}
}
\value{
A \code{glm} object. See \code{\link[stats:glm]{stats::glm()}} for full details.
}
\description{
This function is a wrapper around \code{\link[stats:glm]{stats::glm()}} that uses a column from
\code{data} as an offset.
}
\details{
Outside of the \code{tidymodels} ecosystem, \code{glm_offset()} has no advantages over
\code{\link[stats:glm]{stats::glm()}} since that function allows for offsets to be specified
in the formula interface or its \code{offset} argument.

Within \code{tidymodels}, \code{glm_offset()} provides an advantage because it will
ensure that offsets are included in the data whenever resamples are created.

The \code{formula}, \code{family}, \code{data}, and \code{weights} arguments have the same
meanings as \code{\link[stats:glm]{stats::glm()}}. See that function's documentation for full
details.
}
\examples{
us_deaths$off <- log(us_deaths$population)
glm_offset(deaths ~ age_group + gender, family = "poisson",
           us_deaths, offset_col = "off")

}
\seealso{
\code{\link[stats:glm]{stats::glm()}}
}
