% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{open_file}
\alias{open_file}
\title{Opens a file locally}
\usage{
open_file(path)
}
\arguments{
\item{path}{File path.}
}
\description{
Opening a file locally requires a compatible application to be installed
(e.g., MS Office or LibreOffice for .pptx or .docx files).
}
\details{
\emph{NB:} Function is a small wrapper around \code{\link[utils:browseURL]{utils::browseURL()}} to have a more
suitable function name.
}
\examples{
x <- read_pptx()
x <- add_slide(x, "Title Slide", ctrTitle = "My Title")
file <- print(x, tempfile(fileext = ".pptx"))
\dontrun{
open_file(file)}
}
