% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_table}
\alias{block_table}
\title{Table block}
\usage{
block_table(x, header = TRUE, properties = prop_table(), alignment = NULL)
}
\arguments{
\item{x}{a data.frame to add as a table}

\item{header}{display header if TRUE}

\item{properties}{table properties, see \code{\link[=prop_table]{prop_table()}}.
Table properties are not handled identically between Word and PowerPoint
output format. They are fully supported with Word but for PowerPoint (which
does not handle as many things as Word for tables), only conditional
formatting properties are supported.}

\item{alignment}{alignment for each columns, 'l' for left, 'r' for right
and 'c' for center. Default to NULL.}
}
\description{
Create a representation of a table
}
\examples{
block_table(x = head(iris))

block_table(x = mtcars, header = TRUE,
  properties = prop_table(
    tcf = table_conditional_formatting(
      first_row = TRUE, first_column = TRUE)
  ))
}
\seealso{
\code{\link[=prop_table]{prop_table()}}

Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
