% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{ph_with}
\alias{ph_with}
\alias{ph_with.character}
\alias{ph_with.numeric}
\alias{ph_with.factor}
\alias{ph_with.logical}
\alias{ph_with.block_list}
\alias{ph_with.unordered_list}
\alias{ph_with.data.frame}
\alias{ph_with.gg}
\alias{ph_with.plot_instr}
\alias{ph_with.external_img}
\alias{ph_with.fpar}
\alias{ph_with.empty_content}
\alias{ph_with.xml_document}
\title{add objects into a new shape on the current slide}
\usage{
ph_with(x, value, location, ...)

\method{ph_with}{character}(x, value, location, ...)

\method{ph_with}{numeric}(x, value, location, format_fun = format, ...)

\method{ph_with}{factor}(x, value, location, ...)

\method{ph_with}{logical}(x, value, location, format_fun = format, ...)

\method{ph_with}{block_list}(x, value, location, level_list = integer(0), ...)

\method{ph_with}{unordered_list}(x, value, location, ...)

\method{ph_with}{data.frame}(
  x,
  value,
  location,
  header = TRUE,
  tcf = table_conditional_formatting(),
  alignment = NULL,
  ...
)

\method{ph_with}{gg}(x, value, location, res = 300, alt_text, scale = 1, ...)

\method{ph_with}{plot_instr}(x, value, location, res = 300, ...)

\method{ph_with}{external_img}(x, value, location, use_loc_size = TRUE, ...)

\method{ph_with}{fpar}(x, value, location, ...)

\method{ph_with}{empty_content}(x, value, location, ...)

\method{ph_with}{xml_document}(x, value, location, ...)
}
\arguments{
\item{x}{an rpptx object}

\item{value}{object to add as a new shape. Supported objects
are vectors, data.frame, graphics, block of formatted paragraphs,
unordered list of formatted paragraphs,
pretty tables with package flextable, editable graphics with
package rvg, 'Microsoft' charts with package mschart.}

\item{location}{a placeholder location object.
It will be used to specify the location of the new shape. This location
can be defined with a call to one of the ph_location functions. See
section \code{"see also"}.}

\item{...}{further arguments passed to or from other methods. When
adding a \code{ggplot} object or \code{plot_instr}, these arguments will be used
by png function.}

\item{format_fun}{format function for non character vectors}

\item{level_list}{The list of levels for hierarchy structure as integer values.
If used the object is formated as an unordered list. If 1 and 2,
item 1 level will be 1, item 2 level will be 2.}

\item{header}{display header if TRUE}

\item{tcf}{conditional formatting settings defined by \code{\link[=table_conditional_formatting]{table_conditional_formatting()}}}

\item{alignment}{alignment for each columns, 'l' for left, 'r' for right
and 'c' for center. Default to NULL.}

\item{res}{resolution of the png image in ppi}

\item{alt_text}{Alt-text for screen-readers}

\item{scale}{Multiplicative scaling factor, same as in ggsave}

\item{use_loc_size}{if set to FALSE, external_img width and height will
be used.}
}
\description{
add object into a new shape in the current slide. This
function is able to add all supported outputs to a presentation. See
section \strong{Methods (by class)} to see supported outputs.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: add a character vector to a new shape on the
current slide, values will be added as paragraphs.

\item \code{numeric}: add a numeric vector to a new shape on the
current slide, values will be be first formatted then
added as paragraphs.

\item \code{factor}: add a factor vector to a new shape on the
current slide, values will be be converted as character and then
added as paragraphs.

\item \code{block_list}: add a \code{\link{block_list}} made
of \code{\link{fpar}} to a new shape on the current slide.

\item \code{unordered_list}: add a \code{\link{unordered_list}} made
of \code{\link{fpar}} to a new shape on the current slide.

\item \code{data.frame}: add a data.frame to a new shape on the current slide with
function \code{\link[=block_table]{block_table()}}. Use package \code{flextable} instead for more
advanced formattings.

\item \code{gg}: add a ggplot object to a new shape on the
current slide. Use package \code{rvg} for more advanced graphical features.

\item \code{plot_instr}: add an R plot to a new shape on the
current slide. Use package \code{rvg} for more advanced graphical features.

\item \code{external_img}: add a \code{\link{external_img}} to a new shape
on the current slide.

When value is a external_img object, image will be copied
into the PowerPoint presentation. The width and height
specified in call to \code{external_img} will be
ignored, their values will be those of the location,
unless use_loc_size is set to FALSE.

\item \code{fpar}: add an \code{\link{fpar}} to a new shape
on the current slide as a single paragraph in a \code{\link{block_list}}.

\item \code{empty_content}: add an \code{\link{empty_content}} to a new shape
on the current slide.

\item \code{xml_document}: add an xml_document object to a new shape on the
current slide. This function is to be used to add custom openxml code.
}}

\section{Illustrations}{


\if{html}{\figure{ph_with_doc_1.png}{options: width=80\%}}
}

\examples{
# this name will be used to print the file
# change it to "youfile.pptx" to write the pptx
# file in your working directory.
fileout <- tempfile(fileext = ".pptx")


doc_1 <- read_pptx()
sz <- slide_size(doc_1)
# add text and a table ----
doc_1 <- add_slide(doc_1, layout = "Two Content", master = "Office Theme")
doc_1 <- ph_with(x = doc_1, value = c("Table cars"),
   location = ph_location_type(type = "title") )
doc_1 <- ph_with(x = doc_1, value = names(cars),
   location = ph_location_left() )
doc_1 <- ph_with(x = doc_1, value = cars,
   location = ph_location_right() )

# add a base plot ----
anyplot <- plot_instr(code = {
  col <- c("#440154FF", "#443A83FF", "#31688EFF",
           "#21908CFF", "#35B779FF", "#8FD744FF", "#FDE725FF")
  barplot(1:7, col = col, yaxt="n")
})

doc_1 <- add_slide(doc_1)
doc_1 <- ph_with( doc_1, anyplot,
  location = ph_location_fullsize(),
  bg = "#006699")

# add a ggplot2 plot ----
if( require("ggplot2") ){
  doc_1 <- add_slide(doc_1)
  gg_plot <- ggplot(data = iris ) +
    geom_point(mapping = aes(Sepal.Length, Petal.Length),
               size = 3) +
    theme_minimal()
  doc_1 <- ph_with(x = doc_1, value = gg_plot,
                   location = ph_location_type(type = "body"),
                   bg = "transparent" )
  doc_1 <- ph_with(x = doc_1, value = "graphic title",
                   location = ph_location_type(type="title") )
}

# add a external images ----
doc_1 <- add_slide(doc_1, layout = "Title and Content",
                   master = "Office Theme")
doc_1 <- ph_with(x = doc_1, value = empty_content(),
  location = ph_location(left = 0, top = 0,
    width = sz$width, height = sz$height, bg = "black") )

svg_file <- file.path(R.home(component = "doc"), "html/Rlogo.svg")
if( require("rsvg") ){
  doc_1 <- ph_with(x = doc_1, value = "External images",
                   location = ph_location_type(type = "title") )
  doc_1 <- ph_with(x = doc_1, external_img(svg_file, 100/72, 76/72),
                   location = ph_location_right(), use_loc_size = FALSE )
  doc_1 <- ph_with(x = doc_1, external_img(svg_file),
                   location = ph_location_left(),
                   use_loc_size = TRUE )
}

# add a block_list ----
dummy_text <- readLines(system.file(package = "officer",
  "doc_examples/text.txt"))
fp_1 <- fp_text(bold = TRUE, color = "pink", font.size = 0)
fp_2 <- fp_text(bold = TRUE, font.size = 0)
fp_3 <- fp_text(italic = TRUE, color="red", font.size = 0)
bl <- block_list(
  fpar(ftext("hello world", fp_1)),
  fpar(
    ftext("hello", fp_2),
    ftext("hello", fp_3)
  ),
  dummy_text
)
doc_1 <- add_slide(doc_1)
doc_1 <- ph_with(x = doc_1, value = bl,
   location = ph_location_type(type="body") )


# fpar ------
fpt <- fp_text(bold = TRUE, font.family = "Bradley Hand",
      font.size = 150, color = "#F5595B")
hw <- fpar(
  ftext("hello ", fpt),
  hyperlink_ftext(
    href = "https://cran.r-project.org/index.html",
    text = "cran", prop = fpt)
)
doc_1 <- add_slide(doc_1)
doc_1 <- ph_with(x = doc_1, value = hw,
                 location = ph_location_type(type="body") )
# unordered_list ----
ul <- unordered_list(
  level_list = c(1, 2, 2, 3, 3, 1),
  str_list = c("Level1", "Level2", "Level2", "Level3", "Level3", "Level1"),
  style = fp_text(color = "red", font.size = 0) )
doc_1 <- add_slide(doc_1)
doc_1 <- ph_with(x = doc_1, value = ul,
                 location = ph_location_type() )

print(doc_1, target = fileout )
}
\seealso{
\link{ph_location_type}, \link{ph_location}, \link{ph_location_label},
\link{ph_location_left}, \link{ph_location_right}, \link{ph_location_fullsize},
\link{ph_location_template}
}
