% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_slide_manip.R
\name{move_slide}
\alias{move_slide}
\title{move a slide}
\usage{
move_slide(x, index, to)
}
\arguments{
\item{x}{an rpptx object}

\item{index}{slide index, default to current slide position.}

\item{to}{new slide index.}
}
\description{
move a slide in a pptx presentation
}
\note{
cursor is set on the last slide.
}
\examples{
x <- read_pptx()
x <- add_slide(x)
x <- ph_with(x, "Hello world 1", location = ph_location_type())
x <- add_slide(x)
x <- ph_with(x, "Hello world 2", location = ph_location_type())
x <- move_slide(x, index = 1, to = 2)
}
\seealso{
\code{\link[=read_pptx]{read_pptx()}}

Other functions slide manipulation: 
\code{\link{add_slide}()},
\code{\link{on_slide}()},
\code{\link{remove_slide}()}
}
\concept{functions slide manipulation}
