% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_data_frame_columns.R
\name{delete_data_frame_columns}
\alias{delete_data_frame_columns}
\title{Deleting \code{data.frame} columns}
\usage{
delete_data_frame_columns(df, column_names)
}
\arguments{
\item{df}{A \code{data.frame}.}

\item{column_names}{A \code{character} (\code{vector}), the name(s) of a column of \code{df} to group by.}
}
\value{
The input \code{df} without the columns defined by \code{column_names}.
}
\description{
This function deletes columns of a \code{data.frame} by name.
}
\examples{
df <- data.frame("label" = c("A", "B"), "number" = 1:10)
delete_data_frame_columns(df = df, column_names = "label")
delete_data_frame_columns(df = df, column_names = "number")
delete_data_frame_columns(df = df, column_names = c("label", "number"))

}
