% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_helpers.R
\name{function_body}
\alias{function_body}
\title{Extract function body}
\usage{
function_body(fun, braces = FALSE, nchar = getOption("width") - 4)
}
\arguments{
\item{fun}{A \code{function}.}

\item{braces}{Either \code{FALSE} (default) to remove \code{"{"} and \code{"}"}
at start and end (if any), or \code{TRUE} if not.}

\item{nchar}{An \code{integer}, the maximum number of characters before abbreviation.
Must be at least \code{3}.
By default, \code{nchar = getOption("width") - 4}.}
}
\value{
A \code{character}, the body of \code{f}.
}
\description{
This function extracts the body of a function as a single \code{character}.
}
\examples{
fun <- mean.default
function_body(fun)
function_body(fun, braces = TRUE)
function_body(fun, nchar = 30)

}
