% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odin.R
\name{odin}
\alias{odin}
\alias{odin_}
\title{Create an odin model}
\usage{
odin(x, verbose = NULL, target = NULL, workdir = NULL, validate = NULL,
  pretty = NULL, skip_cache = NULL, compiler_warnings = NULL,
  no_check_unused_equations = NULL, options = NULL)

odin_(x, verbose = NULL, target = NULL, workdir = NULL,
  validate = NULL, pretty = NULL, skip_cache = NULL,
  compiler_warnings = NULL, no_check_unused_equations = NULL,
  options = NULL)
}
\arguments{
\item{x}{Either the name of a file to read, a text string (if
length is greater than 1 elements will be joined with newlines)
or an expression.}

\item{verbose}{Logical scalar indicating if the compilation should
be verbose.  Defaults to the value of the option
\code{odin.verbose} or \code{FALSE} otherwise.}

\item{target}{Compilation target.  Options are "c" and "r",
defaulting to the option \code{odin.target} or "c" otherwise.}

\item{workdir}{Directory to use for any generated files.  This is
only relevant for the "c" target.  Defaults to the value of the
option \code{odin.workdir} or \code{\link[=tempdir]{tempdir()}} otherwise.}

\item{validate}{Validate the model's intermediate representation
against the included schema.  Normally this is not needed and is
intended primarily for development use.  Defaults to the value
of the option \code{odin.validate} or \code{FALSE} otherwise.}

\item{pretty}{Pretty-print the model's intermediate
representation.  Normally this is not needed and is intended
primarily for development use.  Defaults to the value of the
option \code{odin.pretty} or \code{FALSE} otherwise.}

\item{skip_cache}{Skip odin's cache.  This might be useful if the
model appears not to compile when you would expect it to.
Hopefully this will not be needed often.  Defaults to the option
\code{odin.skip_cache} or \code{FALSE} otherwise.}

\item{compiler_warnings}{Previously this attempted detection of
compiler warnings (with some degree of success), but is
currently ignored. This may become supported again in a future
version depending on underlying support in pkgbuild.}

\item{no_check_unused_equations}{If \code{TRUE}, then don't print
messages about unused variables.  Defaults to the option
\code{odin.no_check_unused_equations} or \code{FALSE} otherwise.}

\item{options}{Named list of options.  If provided, then all other
options are ignored.}
}
\value{
An \code{odin_generator} object (an R6 class) which can be used
to create model instances.
}
\description{
Create an odin model from a file, text string(s) or expression.
The \code{odin_} version is a "standard evaluation" escape hatch.
}
\details{
\strong{Do not use \code{odin::odin} in a package; you almost certainly want
to use \link{odin_package} instead.}

A generated model can return information about itself;
\link{odin_ir}
}
\section{User parameters}{


If the model accepts user parameters, then the parameter to the
constructor or the \verb{$set_user()} method can be used to control
the behaviour when unknown user actions are passed into the
model. Possible values are the strings \code{stop} (throw an error),
\code{warning} (issue a warning but keep going), \code{message} (print a
message and keep going) or \code{ignore} (do nothing).  Defaults to
the option \code{odin.unused_user_action}, or \code{warning} otherwise.
}

\section{Delay equations with dde}{


When generating a model one must chose between using the
\code{dde} package to solve the system or the default
\code{deSolve}.  Future versions may allow this to switch when
using \code{run}, but for now this requires tweaking the generated
code to a point where one must decide at generation.  \code{dde}
implements only the Dormand-Prince 5th order dense output solver,
with a delay equation solver that may perform better than the
solvers in deSolve.  For non-delay equations, \code{deSolve} is
very likely to outperform the simple solver implemented.
}

\examples{
## Compile the model; exp_decay here is an R6ClassGenerator and will
## generate instances of a model of exponential decay:
exp_decay <- odin::odin({
  deriv(y) <- -0.5 * y
  initial(y) <- 1
}, target = "r")

## Generate an instance; there are no parameters here so all instances
## are the same and this looks a bit pointless.  But this step is
## required because in general you don't want to have to compile the
## model every time it is used (so the generator will go in a
## package).
mod <- exp_decay$new()

## Run the model for a series of times from 0 to 10:
t <- seq(0, 10, length.out = 101)
y <- mod$run(t)
plot(y, xlab = "Time", ylab = "y", main = "", las = 1)
}
\author{
Rich FitzJohn
}
