% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplacian_eigenvalue_method.R
\name{lad}
\alias{lad}
\title{Laplacian Eigen Value method by Shenyang Huang, Yasmeen Hitti, Guillaume Rabusseau
and Reihaneh Rabbany from their KDD'20 paper Laplacian Change Point Detection for Dynamic Graphs}
\usage{
lad(matlist, k = NULL, short_win, long_win, alpha = 0.05, from_file = NULL)
}
\arguments{
\item{matlist}{The matrix list, where each matrix is an adjacency matrix of the graph.}

\item{k}{The number of eigen values to connsider}

\item{short_win}{The length of the shorter windows}

\item{long_win}{The length of the longer windows}

\item{alpha}{The threshold to declare anomalies}

\item{from_file}{This is an additional parameter only if a file needs to be read}
}
\value{
An object of class lad. LAD is a window based method. It considers short and a long
windows.  The lad object has anomalous scores when taking into account short and long windows
along with the identified anomalies for both short and long windows.
}
\description{
Laplacian Eigen Value method by Shenyang Huang, Yasmeen Hitti, Guillaume Rabusseau
and Reihaneh Rabbany from their KDD'20 paper Laplacian Change Point Detection for Dynamic Graphs
}
\examples{
# We generate a series of networks and add an anomaly at 50th network.
set.seed(1)
networks <- list()
p.or.m.seq <- rep(0.05, 50)
p.or.m.seq[20] <- 0.2  # anomalous network at 20
for(i in 1:50){
  gr <- igraph::erdos.renyi.game(100, p.or.m = p.or.m.seq[i])
  networks[[i]] <- igraph::as_adjacency_matrix(gr)
}
ladobj <- lad(networks, k = 6, short_win = 2, long_win = 4)
ladobj

}
\references{
Huang, S., Hitti, Y., Rabusseau, G., & Rabbany, R. (2020). Laplacian Change
Point Detection for Dynamic Graphs. Proceedings of the ACM SIGKDD International Conference
on Knowledge Discovery and Data Mining, 349–358. https://doi.org/10.1145/3394486.3403077
}
