% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataTypes.R
\name{test_roundtrip}
\alias{test_roundtrip}
\title{Test round tripping a simple table}
\usage{
test_roundtrip(con = DBItest:::connect(DBItest:::get_default_context()),
  columns = "", invert = TRUE, force_sorted = FALSE)
}
\arguments{
\item{con}{An established DBI connection.}

\item{columns}{Table columns to exclude (default) or include, dependent on
the value of \code{invert}. One of \code{datetime}, \code{date}, \code{binary},
\code{integer}, \code{double}, \code{character}, \code{logical}.}

\item{invert}{If \code{TRUE}, change the definition of columns to be inclusive,
rather than exclusive.}

\item{force_sorted}{If \code{TRUE}, a sorted \code{id} column is added to the sent
data, and the received data is sorted by this column before doing the
comparison. This is necessary for some databases that do not preserve row
order.}
}
\description{
This tests all the supported data types, including missing values. It first
writes them to the database, then reads them back and verifies the data is
identical to the original.
}
\details{
This function is not exported and should only be used during tests and as a
sanity check when writing new \code{odbcDataType()} methods.
}
\examples{
\dontrun{
test_roundtrip(con)

# exclude a few columns
test_roundtrip(con, c("integer", "double"))

# Only test a specific column
test_roundtrip(con, "integer", invert = FALSE)
}
}
