% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\docType{methods}
\name{dbConnect,OdbcDriver-method}
\alias{dbConnect,OdbcDriver-method}
\title{Connect to a ODBC compatible database}
\usage{
\S4method{dbConnect}{OdbcDriver}(drv, dsn = NULL, ..., driver = NULL,
  server = NULL, database = NULL, uid = NULL, pwd = NULL,
  .connection_string = NULL)
}
\arguments{
\item{drv}{an object that inherits from \code{\linkS4class{DBIDriver}},
or an existing \code{\linkS4class{DBIConnection}}
object (in order to clone an existing connection).}

\item{dsn}{The Data Source Name.}

\item{...}{Additional ODBC keywords, these will be joined with the other
arguments to form the final connection string.}

\item{driver}{The ODBC driver name.}

\item{server}{The server hostname.}

\item{database}{The database on the server.}

\item{uid}{The user identifer.}

\item{pwd}{The password to use.}

\item{.connection_string}{A complete connection string, useful if you are
copy pasting it from another source. If this argument is used any additional
arguments will be appended to this string.}
}
\description{
Connect to a ODBC compatible database
}
\details{
The connection string keywords are driver dependant. The parameters
documented here are common, but some drivers may not accept them. Please see
the specific driver documentation for allowed parameters,
\url{https://www.connectionstrings.com} is also a useful resource of example
connection strings for a variety of databases.
}
