% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_legende.R
\name{coord_legende}
\alias{coord_legende}
\title{Returns the lon / lat coordinates of a 'leaflet' map's legend}
\usage{
coord_legende(map)
}
\arguments{
\item{map}{objet leaflet.}
}
\value{
Retourne un objet data.frame avec les coordonnees lon/lat de la (ou
des) legende(s). Le type de legende est indique dans le row.names.
}
\description{
Returns the lon / lat coordinates of a 'leaflet' map's legend for
proportional circles, chroropleth, typology, proportional and sapphire
arrows.
}
\details{
Au moins une legende doit exister sur la carte avant de pouvoir connaitre sa
position. Les cartes en ronds proportionnels avec une analyse en classes ont
2 legendes.
}
\examples{

data("donnees_monoloc")
data("depm")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm,
idData = "COD_DEP", varVolume = "POP_2015")
map <- add_legende_ronds(map = map, titre = "POP_2015")
\donttest{
 map
}

coord <- coord_legende(map)
map <- add_legende_ronds(map = map, titre = "POP_2015", lng = 8, lat = 50)
\donttest{
 map
}

}
\seealso{
\code{\link{add_legende_ronds}, \link{add_legende_classes},
\link{add_legende_typo},}

\code{\link{add_legende_joignantes}, \link{add_legende_saphirs},}

\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes},}

\code{\link{leaflet_classes_ronds}, \link{leaflet_typo},
\link{leaflet_oursins}, \link{leaflet_joignantes},}

\code{\link{leaflet_saphirs}}
}
\keyword{documentation}
