% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astronomy.R
\name{angle2hms}
\alias{angle2hms}
\title{Convert Astronomical Angle in Degrees to Hours, Minutes and Seconds}
\usage{
angle2hms(angle)
}
\arguments{
\item{angle}{numerical value giving an angle in degrees}
}
\value{
\link{angle2hms} returns a list containing
values \code{time} (a numerical value for decimal hour, between 0 and 24),
\code{hour}, \code{minute}, and \code{second} (the last of which may have a fractional
part), and \code{string}, a character value indicates the time in hour-minute-second
notation, with the second part to two decimal places and intervening \code{h},
\code{m} and \code{s} characters between the units.
}
\description{
The purpose of \link{angle2hms} is to facilitate comparison of
\code{rightAscension} angles computed by \code{\link[=sunAngle]{sunAngle()}} and \code{\link[=moonAngle]{moonAngle()}}
with angles reported in astronomical sources and software, which
often employ an hour-minute-second notation. In that notation,
decimal hour is computed as 24/360 times the angle in degrees,
and from that decimal hour are compute integer hour and minute
values, plus a decimal second value. It is common in the
astronomical literature to use strings to represent the results,
e.g. with \eqn{11^h40^m48^s.10}{11h40m48s.10} for the
value used in the \dQuote{Examples}; see Chapter 1 of
Meeus (1991) for more on angle calculation and representation.
}
\examples{
# A randomly-chosen example on page 99 of Meeus (1991).
angle2hms(177.74208) # string component 11h50m58s.10

}
\references{
\itemize{
\item Meeus, Jean. Astronomical Algorithms. Second Edition.
Richmond, Virginia, USA: Willmann-Bell, 1991.
}
}
\seealso{
Other things related to astronomy: 
\code{\link{eclipticalToEquatorial}()},
\code{\link{equatorialToLocalHorizontal}()},
\code{\link{julianCenturyAnomaly}()},
\code{\link{julianDay}()},
\code{\link{moonAngle}()},
\code{\link{siderealTime}()},
\code{\link{sunAngle}()},
\code{\link{sunDeclinationRightAscension}()}
}
\author{
Dan Kelley
}
\concept{things related to astronomy}
