% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g1sst.R
\name{read.g1sst}
\alias{read.g1sst}
\title{Read a G1SST file}
\usage{
read.g1sst(file, encoding = NA)
}
\arguments{
\item{file}{character value containing the name of a netcdf file containing G1SST data.}

\item{encoding}{ignored.}
}
\value{
A \linkS4class{g1sst} object.
}
\description{
Read a G1SST file in the netcdf format provided by the ERDDAP server
(see reference 1).
}
\details{
As noted in the documentation for the \linkS4class{g1sst} class, one
must be aware of the incorporation of model simulations in the
\code{g1sst} product. For example, the code presented below
might lead one to believe that the mapped field represents
observations, whereas in fact it can be verified by
consulting reference 2 (clicking and unclicking the radio button to
show just the data) that the field mostly derives from simulation.
}
\examples{
\dontrun{
# Construct query, making it easier to understand and modify.
day <- "2016-01-02"
lon0 <- -66.5
lon1 <- -64.0
lat0 <- 44
lat1 <- 46
source <- paste("https://coastwatch.pfeg.noaa.gov/erddap/griddap/",
                "jplG1SST.nc?",
                "SST\%5B(", day, "T12:00:00Z)",
                "\%5D\%5B(", lat0, "):(", lat1, ")",
                "\%5D\%5B(", lon0, "):(", lon1, ")",
                "\%5D", sep="")
if (!length(list.files(pattern="^a.nc$")))
    download.file(source, "a.nc")
d <- read.g1sst("a.nc")
plot(d, "SST", col=oceColorsTemperature)
if (requireNamespace("ocedata", quietly=TRUE)) {
    data(coastlineWorldFine, package="ocedata")
    lines(coastlineWorldFine[['longitude']],coastlineWorldFine[['latitude']])
}
}

}
\references{
\enumerate{
\item ERDDAP Portal \verb{https://coastwatch.pfeg.noaa.gov/erddap/}
\item JPO OurOcean Portal \verb{https://ourocean.jpl.nasa.gov/SST/}
(link worked in 2016 but was seen to fail 2017 Feb 2).
}
}
\seealso{
Other things related to g1sst data: 
\code{\link{[[,g1sst-method}},
\code{\link{[[<-,g1sst-method}},
\code{\link{g1sst-class}}
}
\author{
Dan Kelley
}
\concept{things related to g1sst data}
