% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{lon360}
\alias{lon360}
\title{Alter longitudes from -180:180 to 0:360 convention}
\usage{
lon360(x)
}
\arguments{
\item{x}{either a numeric vector or array, or an \linkS4class{oce} object.}
}
\description{
For numerical input, including vectors, matrices and arrays,
\code{\link[=lon360]{lon360()}} simply calls \code{\link[=ifelse]{ifelse()}} to add 360 to any negative values. For
\linkS4class{section} objects, it changes \code{longitude} in the \code{metadata} slot
and then calls itself to handle the \linkS4class{ctd} objects stored as
as the entries in \code{station} within the \code{data} slot.
For this \linkS4class{ctd} object, and indeed for all non-\linkS4class{section}
objects, \code{\link[=lon360]{lon360()}} changes \code{longitude} values in the
\code{metadata} slot (if present) and also in the \code{data} slot (again, if
present). This function is not useful for dealing with coastline
data; see \code{\link[=coastlineCut]{coastlineCut()}} for such data.
}
\examples{
lon360(c(179, -179))
}
