% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{read.woa}
\alias{read.woa}
\title{Read a World Ocean Atlas NetCDF File}
\usage{
read.woa(file, name, positive = FALSE, encoding = NA)
}
\arguments{
\item{file}{character string naming the file}

\item{name}{of variable to extract. If not provided, an
error message is issued that lists the names of data in the file.}

\item{positive}{logical value indicating whether \code{longitude} should
be converted to be in the range from 0 to 360, with \code{name}
being shuffled accordingly. This is set to \code{FALSE} by default,
because the usual oce convention is for longitude to range between -180
to +180.}

\item{encoding}{ignored.}
}
\value{
A list containing vectors \code{longitude}, \code{latitude},
\code{depth}, and an array with the specified name. If \code{positive}
is true, then \code{longitude} will be converted to range from 0
to 360, and the array will be shuffled accordingly.
}
\description{
Read a World Ocean Atlas NetCDF File
}
