% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{plot,ctd-method}
\alias{plot,ctd-method}
\alias{plot.ctd}
\title{Plot a ctd Object}
\usage{
\S4method{plot}{ctd}(
  x,
  which,
  col = par("fg"),
  fill,
  borderCoastline = NA,
  colCoastline = "lightgray",
  eos = getOption("oceEOS", default = "gsw"),
  ref.lat = NaN,
  ref.lon = NaN,
  grid = TRUE,
  coastline = "best",
  Slim,
  Clim,
  Tlim,
  plim,
  densitylim,
  N2lim,
  Rrholim,
  dpdtlim,
  timelim,
  drawIsobaths = FALSE,
  clongitude,
  clatitude,
  span,
  showHemi = TRUE,
  lonlabels = TRUE,
  latlabels = TRUE,
  latlon.pch = 20,
  latlon.cex = 1.5,
  latlon.col = "red",
  projection = NULL,
  cex = 1,
  cex.axis = par("cex.axis"),
  pch = 1,
  useSmoothScatter = FALSE,
  df,
  keepNA = FALSE,
  type,
  mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 1.5, mgp[1] + 1.5, mgp[1] + 1.5, mgp[1] + 1),
  inset = FALSE,
  add = FALSE,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{which}{a numeric or character vector specifying desired plot types. If
\code{which} is not supplied, a default will be used. This default depends on
\code{deploymentType} in the \code{metadata} slot of \code{x}.  If \code{deploymentType} is
\code{"profile"} or missing, then \code{which} defaults to \code{c(1,2,3,5)}.  If
\code{deploymentType} is \code{"moored"} or \code{"thermosalinograph"} then \code{which} defaults
to \code{c(30, 3, 31, 5)}. Finally, if \code{deploymentType} is \code{towyo} then \code{which}
defaults to \code{c(30, 31, 32, 3)}.

The details of individual \code{which} values are as follows. Some of the entries
refer to the EOS (equation of state for seawater), which may either \code{"gsw"}
for the modern Gibbs Seawater system, or \code{"unesco"} for the older UNESCO
system. The EOS may be set with the \code{eos} argument to \verb{plot,ctd-method()} or
by using \code{\link[=options]{options()}}, with \code{options(oceEOS="unesco")} or
\code{options(oceEOS="unesco")}. The default EOS is \code{"gsw"}.
\itemize{
\item \code{which=1} or \code{which="salinity+temperature"} gives a combined profile of
temperature and salinity.  If the EOS is \code{"gsw"} then Conservative
Temperature and Absolute Salinity are shown; otherwise in-situ temperature
and practical salinity are shown.
\item \code{which=2} or \code{which="density+N2"} gives a combined profile of density
anomaly, computed with \code{\link[=swSigma0]{swSigma0()}}, along with the square of the buoyancy
frequency, computed with \code{\link[=swN2]{swN2()}}. The \code{eos} parameter is passed
to each of these functions, so the desired EOS is used.
\item \code{which=3} or \code{which="TS"} gives a TS plot. If the EOS is \code{"gsw"}, T is
Conservative Temperature and S is Absolute Salinity; otherwise, they are
in-situ temperature and practical salinity, respectively.
\item \code{which=4} or \code{which="text"} gives a textual  summary of
some aspects of the data.
\item \code{which=5} or \code{which="map"} gives a map plotted with
\code{\link[=plot,coastline-method]{plot,coastline-method()}}, with a dot for the station location.  Notes near
the top boundary of the map give the station number, the sampling date, and
the name of the chief scientist, if these are known. Note that the longitude
will be converted to a value between -180 and 180 before plotting.  (See also
notes about \code{span}.)
\item \code{which=5.1} as for \code{which=5}, except that the file name
is drawn above the map.
\item \code{which=6} or \code{which="density+dpdt"} gives a profile of density and
\eqn{dP/dt}{dP/dt}, which is useful for evaluating whether the instrument is
dropping properly through the water column.  If the EOS is \code{"gsw"} then
\eqn{\sigma_0}{sigma[0]} is shown; otherwise,
\eqn{\sigma_\theta}{sigma[theta]} is shown.
\item \code{which=7} or \code{which="density+time"} gives a profile of density and time.
\item \code{which=8} or \code{which="index"} gives a profile of index number, which can
provide useful information for trimming with \code{\link[=ctdTrim]{ctdTrim()}}.
\item \code{which=9} or \code{which="salinity"} gives a profile of Absolute
Salinity if the EOS is \code{"gsw"}, or practical salinity otherwise.
\item \code{which=10} or \code{which="temperature"} gives a profile
of Conservative Temperature if the EOS is \code{"gsw"}, or
in-situ temperature otherwise.
\item \code{which=11} or \code{which="density"} gives a profile
of density as computed with \code{\link[=swRho]{swRho()}}, to which the \code{eos}
parameter is passed.
\item \code{which=12} or \code{which="N2"} gives an \eqn{N^2}{N^2} profile.
\item \code{which=13} or \code{which="spice"} gives a spiciness profile.
\item \code{which=14} or \code{which="tritium"} gives a tritium profile.
\item \code{which=15} or \code{which="Rrho"} gives a diffusive-case density
ratio profile.
\item \code{which=16} or \code{which="RrhoSF"} gives a salt-finger case
density ratio profile.
\item \code{which=17} or \code{which="conductivity"} gives a conductivity profile.
\item \code{which=20} or \code{which="CT"} gives a profile of Conservative Temperature.
\item \code{which=21} or \code{which="SA"} gives a profile of Absolute Salinity.
\item \code{which=30} or \code{which="Sts"} gives a time series of Salinity Absolute
Salinity if the EOS is \code{"gsw"} or practical salinity otherwise.
\item \code{which=31} or \code{which="Tts"} gives a time series of Conservative Temperature
if the EOS is \code{"gsw"} or in-situ temperature otherwise.
\item \code{which=32} or \code{which="pts"} gives a time series of pressure
\item \code{which=33} or \code{which="rhots"} gives a time series of density anomaly,
\eqn{\sigma_0}{sigma[0]} if the EOS is \code{"gsw"}
or \eqn{\sigma_\theta}{sigma[theta]} otherwise.
\item otherwise, \code{which} is interpreted as a character value to be checked
against the \code{data} and \code{dataDerived} fields returned by \verb{x[["?"]}. If a match
is found then a profile of the corresponding quantity is plotted.  If there
is no match, an error is reported.
}}

\item{col}{color of lines or symbols.}

\item{fill}{a legacy parameter that will be permitted only temporarily; see
\dQuote{History}.}

\item{borderCoastline}{color of coastlines and international borders, passed
to \code{\link[=plot,coastline-method]{plot,coastline-method()}} if a map is included in \code{which}.}

\item{colCoastline}{fill color of coastlines and international borders, passed
to \code{\link[=plot,coastline-method]{plot,coastline-method()}} if a map is included in \code{which}. Set to
\code{NULL} to avoid filling.}

\item{eos}{character value indicating the equation of state to be used, either
\code{"unesco"} or \code{"gsw"}.  The default is to use a value stored with
\code{\link[=options]{options()}} as e.g. \code{options(oceEOS="unesco")}.}

\item{ref.lat}{latitude of reference point for distance calculation.
The permitted range is -90 to 90.}

\item{ref.lon}{longitude of reference point for distance calculation.
The permitted range is -180 to 180.}

\item{grid}{logical value indicating whether to draw a grid on the plot.}

\item{coastline}{a specification of the coastline to be used for
\code{which="map"}.  This may be a coastline object, whether built-in or
supplied by the user, or a character string.  If the later, it may be the
name of a built-in coastline (\code{"coastlineWorld"},
\code{"coastlineWorldFine"}, or
\code{"coastlineWorldCoarse"}), or \code{"best"}, to choose
a suitable coastline for the locale, or \code{"none"} to prevent
the drawing of a coastline.  There is a speed penalty for providing
\code{coastline} as a character string, because it forces
\code{\link[=plot,coastline-method]{plot,coastline-method()}} to load it on every call.  So, if
\code{\link[=plot,coastline-method]{plot,coastline-method()}} is to be called several times for a given
coastline, it makes sense to load it in before the first call, and to
supply the object as an argument, as opposed to the name of the object.}

\item{Slim, Clim, Tlim, plim, densitylim, N2lim, Rrholim, dpdtlim, timelim}{optional
numeric vectors of length 2, that give axis limits for salinity,
conductivity, temperature, pressure, the square of buoyancy frequency,
density ratio, dp/dt, and time, respectively.}

\item{drawIsobaths}{logical value indicating whether to draw depth contours on
maps, in addition to the coastline. The argument has no effect except
for panels in which the value of \code{which} equals \code{"map"} or
the equivalent numerical code, \code{5}. If \code{drawIsobaths} is
\code{FALSE}, then no contours are drawn. If \code{drawIsobaths}
is \code{TRUE}, then contours are selected automatically,
using \link{pretty}\code{(c(0,300))} if the station depth is
under 100m or \link{pretty}\code{(c(0,5500))} otherwise.
If \code{drawIsobaths} is a numerical vector,
then the indicated depths are drawn. For plots drawn with \code{projection}
set to \code{NULL}, the contours are added with \code{\link[=contour]{contour()}}
and otherwise \code{\link[=mapContour]{mapContour()}} is used. To customize
the resultant contours, e.g. setting particular line types or colors,
users should call these functions directly (see e.g. Example 2).}

\item{clongitude, clatitude, span}{controls for the map area view,
used only if \code{which="map"}.
\code{clongitude} and \code{clatitude} specify the centre of the view, and
\code{span} specifies the approximate extend of the view, in
kilometres.  (If \code{span} is not given, it is be determined as a small
multiple of the distance to the nearest point of land, in an attempt to show
the station in familiar geographical context.)}

\item{showHemi, lonlabels, latlabels}{controls for axis labelling, used only if \code{which="map"}.
\code{showHemi} is logical value indicating whether to show hemisphere in axis tick
labels. \code{lonlabels} and \code{latlabels} are numeric and character values that control the
axis labelling.}

\item{latlon.pch, latlon.cex, latlon.col}{controls for station location,
used only if \code{which="map"}.  \code{latlon.pch} sets the symbol code,
\code{latlon.cex} sets the character expansion
factor, and \code{latlon.col} sets the colour.}

\item{projection}{controls the map projection (if any), and ignored unless
\code{which="map"}. The possibilities are as follows.  (1) If \code{projection=NULL}
(the default) then no projection will be used; the map will simply show
longitude and latitude in a Cartesian frame, scaled to retain shapes at the
centre.  (2) If \verb{projection=}"automatic"\verb{then either a Mercator or Stereographic projection will be used, depending on whether the CTD station is within 70 degrees of the equator or at higher latitudes. (3) If}projection` is a string in the format used by \code{\link[=mapPlot]{mapPlot()}}, then it is is
passed to that function.}

\item{cex}{size to be used for plot symbols (see \code{\link[=par]{par()}}).}

\item{cex.axis}{size factor for axis labels (see \code{\link[=par]{par()}}).}

\item{pch}{code for plotting symbol (see \code{\link[=par]{par()}}).}

\item{useSmoothScatter}{logical value indicating whether to
use \code{\link[=smoothScatter]{smoothScatter()}} instead of \code{\link[=plot]{plot()}} to draw the plot.}

\item{df}{optional numeric argument that is ignored except for plotting buoyancy
frequency; in that case, it is passed to \code{\link[=swN2]{swN2()}}.}

\item{keepNA}{logical value indicating whether \code{NA} values
will yield breaks in lines drawn if \code{type} is \code{b}, \code{l}, or \code{o}.
The default value is \code{FALSE}.  Setting \code{keepNA} to \code{TRUE}
can be helpful when working with multiple profiles
strung together into one \linkS4class{ctd} object, which otherwise
would have extraneous lines joining the deepest point in one
profile to the shallowest in the next profile.}

\item{type}{the type of plot to draw, using the same scheme as
\code{\link[=plot]{plot()}}. If supplied, this is increased to be the
same length as \code{which}, if necessary, and then supplied to
each of the individual plot calls. If it is not supplied,
then those plot calls use defaults (e.g. using a line for
\code{\link[=plotProfile]{plotProfile()}}, using dots for \code{\link[=plotTS]{plotTS()}},
etc).}

\item{mgp}{three-element numerical vector specifying axis-label geometry,
passed to \code{\link[=par]{par()}}.
The default establishes tighter margins than in the usual R setup.}

\item{mar}{four-element numerical vector specifying margin geometry,
passed to \code{\link[=par]{par()}}.
The default establishes tighter margins than in the usual R setup.
Note that the value of \code{mar} is ignored for the map panel
of multi-panel maps; instead, the present value of
\link{par}\code{("mar")} is used, which in the default call will
make the map plot region equal that of the previously-drawn
profiles and TS plot.}

\item{inset}{logical value indicating whether this
function is being used as an inset.  The
effect is to prevent the present function from adjusting margins, which is
necessary because margin adjustment is the basis for the method used by
\code{\link[=plotInset]{plotInset()}}.}

\item{add}{logical value indicating whether to add to an existing plot.  This
only works if \code{length(which)=1}, and it will yield odd results if the
value of \code{which} does not match that in the previous plots.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}

\item{...}{optional arguments passed to plotting functions.}
}
\description{
Plot CTD data in any of many different ways. In many cases,
the best choice is to use default values for all parameters
other than the first.  This yields a 4-panel plot that
displays a basic overview of the data, with a combined
profile of salinity and temperature at the top
left, a combined plot of density and the square of buoyancy
frequency at top right, a TS diagram at bottom left, and
a map at bottom right.
}
\details{
The
default values of \code{which} and other arguments are chosen to be useful
for quick overviews of data. However, for detailed work it is common
to call the present function with just a single value of \code{which}, e.g.
with four calls to get four panels. The advantage of this is that it provides
much more control over the display, and also it permits the addition of extra
display elements (lines, points, margin notes, etc.) to the individual panels.

Note that panels that draw more than one curve (e.g. \code{which="salinity+temperature"}
draws temperature and salinity profiles in one graph), the value of \link{par}\code{("usr")}
is established by the second profile to have been drawn. Some experimentation will
reveal what this profile is, for each permitted \code{which} case, although
it seems unlikely that this will help much ... the simple fact is that drawing two
profiles in one graph is useful for a quick overview, but not useful for e.g. interactive
analysis with \code{\link[=locator]{locator()}} to flag bad data, etc.
}
\section{History of Changes}{

\itemize{
\item January 2022:
\itemize{
\item Add ability to profile anything stored in the \code{data} slot, and anything
that can be computed from information in that slot. The list of
possibilities is found by examining the \code{data} and \code{dataDerived} elements
of \code{x[["?"]]}.
\item Drop the \code{lonlim} and \code{latlim} parameters, marked for removal in 2014;
use \code{clongitude}, \code{clatitude} and \code{span} instead (see
\code{\link[=plot,coastline-method]{plot,coastline-method()}}).
}
\item February 2016:
\itemize{
\item Drop the \code{fill} parameter for land colour; use \code{colCoastline} instead.
\item Add the \code{borderCoastline} argument, to control the colour of coastlines
and international boundaries.
}
}
}

\examples{
## 1. simple plot
library(oce)
data(ctd)
plot(ctd)

## 2. how to customize depth contours
par(mfrow=c(1,2))
data(section)
stn <- section[["station", 105]]
plot(stn, which="map", drawIsobaths=TRUE)
plot(stn, which="map")
data(topoWorld)
tlon <- topoWorld[["longitude"]]
tlat <- topoWorld[["latitude"]]
tdep <- -topoWorld[["z"]]
contour(tlon, tlat, tdep, drawlabels=FALSE,
        levels=seq(1000,6000,1000), col='lightblue', add=TRUE)
contour(tlon, tlat, tdep, vfont=c("sans serif", "bold"),
        levels=stn[['waterDepth']], col='red', lwd=2, add=TRUE)

}
\seealso{
The documentation for \linkS4class{ctd} explains the structure of CTD
objects, and also outlines the other functions dealing with them.

Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to ctd data}
