% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\docType{data}
\name{sealevelTuktoyaktuk}
\alias{sealevelTuktoyaktuk}
\title{Sea-level data set acquired in 1975 at Tuktoyaktuk}
\source{
The data were based on the \code{T_TIDE} dataset, which in turn
seems to be based on Appendix 7.2 of Foreman (1977).  Minor editing was on
file format, and then the \code{sealevelTuktoyaktuk} object was created
using \code{\link[=as.sealevel]{as.sealevel()}}.
}
\description{
This sea-level dataset is provided with in Appendix 7.2 of Foreman (1977)
and also with the \code{T_TIDE} package (Pawlowicz et al., 2002). It results
from measurements made in 1975 at Tuktoyaktuk, Northwest Territories,
Canada.
}
\details{
The data set contains 1584 points, some of which have NA for sea-level
height.

Although Foreman's Appendix 7.2 states that times are in Mountain standard
time, the timezone is set to \code{UTC} in the present case, so that the
results will be similar to those he provides in his Appendix 7.3.
}
\section{Historical note}{

Until Jan 6, 2018, the time in this dataset had been increased
by 7 hours. However, this alteration was removed on this date,
to make for simpler comparison of amplitude and phase output with
the results obtained by Foreman (1977) and Pawlowicz et al. (2002).
}

\examples{
\donttest{
library(oce)
data(sealevelTuktoyaktuk)
time <- sealevelTuktoyaktuk[["time"]]
elevation <- sealevelTuktoyaktuk[["elevation"]]
oce.plot.ts(time, elevation, type='l', ylab="Height [m]", ylim=c(-2, 6))
legend("topleft", legend=c("Tuktoyaktuk (1975)","Detided"),
       col=c("black","red"),lwd=1)
tide <- tidem(sealevelTuktoyaktuk)
detided <- elevation - predict(tide)
lines(time, detided, col="red")
}

}
\references{
Foreman, M. G. G., 1977.  Manual for tidal heights analysis and
prediction.  Pacific Marine Science Report 77-10, Institute of Ocean
Sciences, Patricia Bay, Sidney, BC, 58pp.

Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002.  Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
\seealso{
Other datasets provided with oce: 
\code{\link{adp}},
\code{\link{adv}},
\code{\link{amsr}},
\code{\link{argo}},
\code{\link{cm}},
\code{\link{coastlineWorld}},
\code{\link{ctdRaw}},
\code{\link{ctd}},
\code{\link{echosounder}},
\code{\link{landsat}},
\code{\link{lisst}},
\code{\link{lobo}},
\code{\link{met}},
\code{\link{ocecolors}},
\code{\link{rsk}},
\code{\link{sealevel}},
\code{\link{section}},
\code{\link{topoWorld}},
\code{\link{wind}},
\code{\link{xbt}}

Other things related to sealevel data: 
\code{\link{[[,sealevel-method}},
\code{\link{[[<-,sealevel-method}},
\code{\link{as.sealevel}()},
\code{\link{plot,sealevel-method}},
\code{\link{read.sealevel}()},
\code{\link{sealevel-class}},
\code{\link{sealevel}},
\code{\link{subset,sealevel-method}},
\code{\link{summary,sealevel-method}}
}
\concept{datasets provided with oce}
\concept{things related to sealevel data}
