% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat.R
\name{landsatAdd}
\alias{landsatAdd}
\title{Add a Band to a landsat Object}
\usage{
landsatAdd(x, data, name, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{a \linkS4class{landsat} object.}

\item{data}{A matrix of data, with dimensions matching that of entries already in \code{x}.}

\item{name}{The name to be used for the data, i.e. the data can later be
accessed with \code{d[[name]]} where \code{d} is the name of the return value
from the present function.}

\item{debug}{A flag that turns on debugging.  Set to 1 to get a moderate amount of debugging
information, or a higher value for more debugging.}
}
\value{
A \linkS4class{landsat} object, with a new data band.
}
\description{
Add a band to a \linkS4class{landsat} object. Note that
it will be stored in numeric form, not raw form, and therefore
it will require much more storage than data read with
\code{\link[=read.landsat]{read.landsat()}}.
}
\seealso{
The documentation for the \linkS4class{landsat} class explains the
structure of landsat objects, and also outlines the other functions dealing
with them.

Other things related to landsat data: 
\code{\link{[[,landsat-method}},
\code{\link{[[<-,landsat-method}},
\code{\link{landsat-class}},
\code{\link{landsatTrim}()},
\code{\link{landsat}},
\code{\link{plot,landsat-method}},
\code{\link{read.landsat}()},
\code{\link{summary,landsat-method}}
}
\author{
Dan Kelley
}
\concept{satellite}
\concept{things related to landsat data}
