% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisst.R
\docType{class}
\name{lisst-class}
\alias{lisst-class}
\title{Class to Store LISST Data}
\description{
This class stores LISST (Laser in-situ scattering and transmissometry) data.
}
\details{
One may read \code{lisst} objects with \code{\link{read.lisst}},
generate them with \code{\link{as.lisst}}, plot them
with \code{\link{plot,lisst-method}}, and summarize them with
\code{\link{summary,lisst-method}}. Elements may be extracted
with \code{\link{[[,lisst-method}} or replaced with
\code{\link{[[<-,lisst-method}}.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{lisst} objects is a
\code{\link{list}} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{lisst} objects is a \code{\link{list}} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{lisst} objects is a
\code{\link{list}} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link{processingLogShow}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \code{lisst} objects (see \code{\link{[[<-,lisst-method}}),
it is better to use \code{\link{oceSetData}}
and \code{\link{oceSetMetadata}}, because that will save an entry
in the \code{processingLog} to describe the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \code{lisst}
object named \code{lisst} may be retrieved in the standard R way. For example,
\code{slot(lisst, "data")} and \code{slot(lisst, "metadata")} return
the \code{data} and \code{metadata} slots, respectively. The
\code{\link{[[,lisst-method}} operator can also be used to access slots,
with \code{lisst[["data"]]} and \code{lisst[["metadata"]]}, respectively.
Furthermore, \code{\link{[[,lisst-method}} can be used to retrieve
named items (and potentially some derived items) within the
\code{metadata} and \code{data} slots, the former taking precedence
over the latter in the lookup. It is also possible
to find items more directly, using \code{\link{oceGetData}} and
\code{\link{oceGetMetadata}}, but this cannot retrieve derived items.
}

\references{
A users's manual for the LISST-100 instrument is available at
the manufacturer's website \url{http://www.sequoiasci.com}.
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{lobo-class}}, \code{\link{met-class}},
  \code{\link{oce-class}}, \code{\link{odf-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{lisst} data: \code{\link{[[,lisst-method}},
  \code{\link{[[<-,lisst-method}}, \code{\link{as.lisst}},
  \code{\link{plot,lisst-method}},
  \code{\link{read.lisst}},
  \code{\link{summary,lisst-method}}
}
\author{
Dan Kelley
}
\concept{classes provided by \code{oce}}
\concept{things related to \code{lisst} data}
