% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\name{unitFromStringRsk}
\alias{unitFromStringRsk}
\title{Infer Rsk units from a vector of strings}
\usage{
unitFromStringRsk(s)
}
\arguments{
\item{s}{Vector of character strings, holding the `units` entry in the
\code{channels} table of the \code{.rsk} database.}
}
\value{
List of unit lists.
}
\description{
This is used by \code{\link{read.rsk}} to infer the units of data, based
on strings stored in \code{.rsk} files. Lacking a definitive guide
to the format of these file, this function was based on visual inspection
of the data contained within a few sample files; unusual sensors may
not be handled properly.
}
\seealso{
Other functions that interpret variable names and units from headers: \code{\link{ODFNames2oceNames}},
  \code{\link{cnvName2oceName}},
  \code{\link{unitFromString}},
  \code{\link{woceNames2oceNames}}
}
