% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\docType{methods}
\name{subset,echosounder-method}
\alias{subset,echosounder-method}
\title{Subset an Echosounder Object}
\usage{
\S4method{subset}{echosounder}(x, subset, ...)
}
\arguments{
\item{x}{a \code{echosounder} object.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.  See \sQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
A new \code{echosounder} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
Subsetting can be by \code{time} or \code{depth}, but these may not be
combined; use a sequence of calls to subset by both.
}
\examples{
library(oce)
data(echosounder)
plot(echosounder)
plot(subset(echosounder, depth < 10))
plot(subset(echosounder, time < mean(range(echosounder[['time']]))))

}
\seealso{
Other things related to \code{echosounder} data: \code{\link{[[,echosounder-method}},
  \code{\link{[[<-,echosounder-method}},
  \code{\link{as.echosounder}},
  \code{\link{echosounder-class}},
  \code{\link{echosounder}}, \code{\link{findBottom}},
  \code{\link{plot,echosounder-method}},
  \code{\link{read.echosounder}},
  \code{\link{summary,echosounder-method}}
}
\author{
Dan Kelley
}
