% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\name{as.met}
\alias{as.met}
\title{Coerce Data into Met Object}
\usage{
as.met(time, temperature, pressure, u, v,
  filename = "(constructed from data)")
}
\arguments{
\item{time}{Vector of obseration times (or character strings that can be
coerced into times).}

\item{temperature}{vector of temperatures.}

\item{pressure}{vector of pressures.}

\item{u}{vector of eastward wind speed in m/s.}

\item{v}{vector of northward wind speed in m/s.}

\item{filename}{optional string indicating data source}
}
\value{
An object of \code{\link{met-class}}.
}
\description{
Coerces a dataset into a met dataset.
This function is used by \code{\link{read.met}}, and may be used to
construct objects that behave as though read by that function.
}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{met-class}},
  \code{\link{met}}, \code{\link{plot,met-method}},
  \code{\link{read.met}}, \code{\link{subset,met-method}},
  \code{\link{summary,met-method}}
}

