% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\docType{methods}
\name{summary,topo-method}
\alias{summary,topo-method}
\title{Summarize A Topo Object}
\usage{
\S4method{summary}{topo}(object, ...)
}
\arguments{
\item{object}{A \code{topo} object, i.e. inheriting from \code{\link{topo-class}}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A matrix containing statistics of the elements of the \code{data} slot.
}
\description{
Pertinent summary information is presented, including the longitude and
latitude range, and the range of elevation.
}
\examples{
library(oce)
data(topoWorld)
summary(topoWorld)

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{topo} data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{plot,topo-method}}, \code{\link{read.topo}},
  \code{\link{subset,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}},
  \code{\link{topoWorld}}
}

