% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\docType{methods}
\name{subset,ctd-method}
\alias{subset,ctd-method}
\alias{subset.ctd}
\title{Subset a CTD object}
\usage{
\S4method{subset}{ctd}(x, subset, ...)
}
\arguments{
\item{x}{An object inheriting from \code{\link{ctd-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{...}{Ignored.}
}
\value{
A ctd object.
}
\description{
This function is somewhat analogous to
\code{\link{subset.data.frame}}, but only one independent variable may be
used in \code{subset} in any call to the function, which means that
repeated calls will be necessary to subset based on more than one
independent variable (e.g. time and distance).
}
\examples{
library(oce)
data(ctd)
plot(ctd)
plot(subset(ctd, pressure<10))
}

