% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questionnaire_pages.R
\name{page_second_freetext}
\alias{page_second_freetext}
\title{An optional, second free text question if the first didn't yield suggestions.}
\usage{
page_second_freetext(
  combine_input_with_first = TRUE,
  is_interview = FALSE,
  aggregate_score_threshold = 0.02,
  ...
)
}
\arguments{
\item{combine_input_with_first}{Should input be combined with the
previous question?}

\item{is_interview}{Should the page show slightly different / additional
instructions and answer options for an interview that is conducted by
another person? Defaults to FALSE.}

\item{aggregate_score_threshold}{The total sum of the scores of the
suggestions has to be higher than this threshold for suggestions to be
shown. The parameter is passed on to \code{\link[=get_job_suggestions]{get_job_suggestions()}}.}

\item{...}{All additional parameters are passed to \code{\link[=new_page]{new_page()}}}
}
\value{
A page object.
}
\description{
If the first freetext question didn't provide satisfactory results,
ask for more details and try again.
}
\examples{
my_questionnaire <- list(
  page_first_freetext(),
  page_second_freetext(),
  page_select_suggestion(),
  page_none_selected_freetext(),
  page_followup(1),
  page_followup(2)
)
if (interactive()) {
  app(questionnaire = my_questionnaire)
}
}
\seealso{
\code{\link[=new_page]{new_page()}}
}
