% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page.R
\name{get_item_data}
\alias{get_item_data}
\title{Retrieve data for an item.}
\usage{
get_item_data(
  session,
  page_id,
  item_id = NULL,
  key = c("all", "question_text", "response_text", "response_id"),
  default = NULL
)
}
\arguments{
\item{session}{The shiny session}

\item{page_id}{The page for which to retrieve data.}

\item{item_id}{The item for which to retrieve data.
This \emph{has} to be different for different items on the same page.
Since most pages contain only a single question/item, \code{item_id} is set to "default" if missing.}

\item{key}{The key for which to retrieve a value. (Optional)
If no key is provided, the items's whole data will be returned.}

\item{default}{A default value to return if the key or page is not
present in the questionnaire data.}
}
\value{
The items's data.
}
\description{
Each page in the questionnaire can have multiple items on it.
}
\examples{
# Set up a "fake" shiny session to store data
session <- shiny::MockShinySession$new()
session$userData <- list(
  current_page_id = "other_page",
  questionnaire_data = list(
    example_page = list()
  )
)

# This code is expected to be run in e.g. run_before or run_after
# It doesn't really make sense to run this code outside
set_item_data(
  session = session,
  page_id = "example_page",
  question_text = "How are you?"
)

# This code is expected to be run in e.g. run_before
get_item_data(
  session = session,
  page_id = "example_page"
)
}
\seealso{
\code{\link[=set_item_data]{set_item_data()}}
}
