% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonRectification.R
\name{taxonRectification}
\alias{taxonRectification}
\title{Taxon Rectification}
\usage{
taxonRectification(taxName = NULL, datasources = NULL, skipTaxize = FALSE)
}
\arguments{
\item{taxName}{A string that, ideally, is a taxonomic name}

\item{datasources}{A vector of taxonomic data sources implemented in
\code{taxize::gnr_resolve()}. See the
\href{http://gni.globalnames.org/}{Global Names List} for more information.}

\item{skipTaxize}{If \code{skipTaxize = TRUE}, occCite will skip taxonomic
rectification using taxize, which has been orphaned on CRAN. Setting this
option to `TRUE` will result in a check for the \code{taxize} package before taxonomic
rectification is attempted. *The code using `taxize` has been disabled to comply with CRAN.*}
}
\value{
A string with the closest match according to
\code{taxize::gnr_resolve()}, and a list of taxonomic data sources that
contain the matching name.
}
\description{
An function that takes an input taxonomic name, checks against
taxonomic database, returns vector for use in database queries, as well as
warnings if the name is invalid.
}
\examples{
# Inputting taxonomic name and specifying what taxonomic sources to search
taxonRectification(
  taxName = "Buteo buteo hartedi",
  datasources = "National Center for Biotechnology Information",
  skipTaxize = TRUE
)
}
