% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGBIFpoints.R
\name{getGBIFpoints}
\alias{getGBIFpoints}
\title{Download occurrence points from GBIF}
\usage{
getGBIFpoints(
  taxon,
  GBIFLogin = GBIFLogin,
  GBIFDownloadDirectory = NULL,
  checkPreviousGBIFDownload = T
)
}
\arguments{
\item{taxon}{A single species}

\item{GBIFLogin}{An object of class \code{\link{GBIFLogin}} to log in to
GBIF to begin the download.}

\item{GBIFDownloadDirectory}{An optional argument that specifies the local
directory where GBIF downloads will be saved. If this is not specified, the
downloads will be saved to your current working directory.}

\item{checkPreviousGBIFDownload}{A logical operator specifying whether the
user wishes to check their existing prepared downloads on the GBIF website.}
}
\value{
A list containing \enumerate{ \item a data frame of occurrence data;
\item GBIF search metadata; \item a data frame containing the raw results of
a query to \code{rgbif::occ_download_get()}.}
}
\description{
Downloads occurrence points and useful related information
for processing within other occCite functions
}
\examples{
\dontrun{
getGBIFpoints(
  taxon = "Gadus morhua",
  GBIFLogin = myGBIFLogin,
  GBIFDownloadDirectory = NULL
)
}

}
