% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_nzffd.R
\name{nzffd_import}
\alias{nzffd_import}
\title{Import NZ Freshwater Fish datasets.}
\usage{
nzffd_import(
  catchment = "",
  river = "",
  location = "",
  fish_method = "",
  species = "",
  starts = 1850,
  ends = 2100
)
}
\arguments{
\item{catchment}{catchment number. a 6 digit number unique to the reach of
interest. You can search using the indidviual number (e.g. \code{catchment =
"702.500"}), or for all rivers in a catchment you can use the wildcard
search term (e.g. \code{catchment = "702\%"}), or don't set the arg if you
want all catchments in NZ.}

\item{river}{river name. e.g. to get all records for the Clutha, \code{river
= "Clutha"}.}

\item{location}{sampling locality. e.g. \code{location = "Awakino"}. This
only works when the location is included in the name of the waterway.}

\item{fish_method}{fishing method used. There are 59 different possible
options for \code{fish_method}, if you want to search for a specific fishing
method look at the dataset \code{?nzffd_method} to see a list of all possible
options, you can then copy/paste from there (e.g. if we only wanted fish
caught be lures use \code{fish_meth = "Angling - Lure"}) don't set the arg
if you want all fishing methods.}

\item{species}{species of interest.There are 75 different possible options
for species, use \code{?nzffd_species} function to see a list of all
possible options. You can search using either common or scientific names
and can search for multiple species at once. e.g. to search for Black
mudfish use \code{species = "Black mudfish"} or \code{species = "Neochanna
diversus"} and to search for Black mudfish and Bluegill bully use \code{
species = c("Black mudfish", "Bluegill bully")} etc.}

\item{starts}{start year, 1850 at the earliest.}

\item{ends}{end year.}
}
\value{
A dataframe consisting of 22 columns where each row is a record for
an individual species. The number of rows will depend on search terms.
}
\description{
Import data from the NZ Freshwater Fish Database. Enter search terms as 
arguments as you would in the NZFFD and import directly into R. You can 
search using all the same query options which are
used for the \href{https://nzffdms.niwa.co.nz/search}{NZFFFD}, see their
\href{https://niwa.co.nz/freshwater-and-estuaries/nzffd/user-guide/tips}{help page} 
for details. To import the entire database leave all arguments blank.
}
\details{
This function requires an internet connection to query NIWA's database.

Data citation: Crow S (2017). New Zealand Freshwater Fish Database. Version
1.2. The National Institute of Water and Atmospheric Research (NIWA).
Occurrence Dataset https://doi.org/10.15468/ms5iqu
}
\examples{
\dontrun{

df <- nzffd_import(nzffdr::nzffd_data)
}
}
