% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bin.R
\name{f_bin}
\alias{f_bin}
\alias{f_bin_text}
\alias{f_bin_text_right}
\alias{f_bin_right}
\alias{ff_bin}
\alias{ff_bin_text}
\alias{ff_bin_right}
\alias{ff_bin_text_right}
\alias{f_interval}
\alias{f_interval_text}
\alias{f_interval_text_right}
\alias{f_interval_right}
\alias{ff_interval}
\alias{ff_interval_text}
\alias{ff_interval_text_right}
\alias{ff_interval_right}
\title{Convert Binned Intervals to Readable Form}
\usage{
f_bin(x, l = "<", le = "<=", parse = FALSE, ...)

f_bin_text(
  x,
  greater = "Greater than",
  middle = "to",
  less = "less than",
  equal = "or equal to",
  ...
)

f_bin_text_right(x, l = "up to", le = "to", equal.digits = FALSE, ...)

f_bin_right(x, l = "<", le = "<=", equal.digits = FALSE, parse = FALSE, ...)

ff_bin(l = "<", le = "<=", parse = TRUE, ...)

ff_bin_text(
  greater = "Greater than",
  middle = "to",
  less = "less than",
  equal = "or equal to",
  ...
)

ff_bin_right(l = "<", le = "<=", equal.digits = FALSE, parse = TRUE, ...)

ff_bin_text_right(l = "up to", le = "to", equal.digits = FALSE, ...)

f_interval(x, l = "<", le = "<=", parse = FALSE, ...)

f_interval_text(
  x,
  greater = "Greater than",
  middle = "to",
  less = "less than",
  equal = "or equal to",
  ...
)

f_interval_text_right(x, l = "up to", le = "to", equal.digits = FALSE, ...)

f_interval_right(
  x,
  l = "<",
  le = "<=",
  equal.digits = FALSE,
  parse = FALSE,
  ...
)

ff_interval(l = "<", le = "<=", parse = TRUE, ...)

ff_interval_text(
  greater = "Greater than",
  middle = "to",
  less = "less than",
  equal = "or equal to",
  ...
)

ff_interval_text_right(l = "up to", le = "to", equal.digits = FALSE, ...)

ff_interval_right(l = "<", le = "<=", equal.digits = FALSE, parse = TRUE, ...)
}
\arguments{
\item{x}{A vector of binned numbers from \code{cut}.}

\item{l}{Less than symbol.}

\item{le}{Less than or equal to symbol.}

\item{parse}{logical.  If \code{TRUE} is parsed for \pkg{ggplot2} facet labels.}

\item{greater}{String to use for greater.}

\item{middle}{String to use for middle  (defaults to \code{'to'}).}

\item{less}{String to use for less.}

\item{equal}{String to use for equal to.  This is combined with the \code{less} or \code{greater}.}

\item{equal.digits}{logical.  If \code{TRUE} digits are given equal number of decimal places.}

\item{\ldots}{ignored.}
}
\value{
\code{f_bin} - Returns human readable intervals in symbol form.

\code{f_bin} - Returns human readable intervals in word form.

\code{f_bin_text_right} - Returns human readable right hand of intervals in word form.

\code{f_bin_right} - Returns human readable right hand intervals in symbol form.
}
\description{
\code{f_bin} - Convert binned intervals to symbol form (e.g., \code{"1 < x <= 3"}).

\code{f_bin_text} - Convert binned intervals to text form (e.g., \code{"Greater than or equal to 1 to less than 3"}).
}
\examples{
x <- cut(-1:5, 3, right = FALSE)
y <- cut(-4:10, c(-5, 2, 6, 10), right = TRUE)
z <- cut(-4:10, c(-4, 2, 6, 11), right = FALSE)

f_bin(x)
f_interval(x) #`_interval` and `_bin` are interchangeable aliases in the function names
f_bin(y)
f_bin(z)
## HTML
f_bin(z, le = '&le;')

f_bin_text(x)
f_bin_text(y)
f_bin_text(z)
f_bin_text(x, middle = 'but')
f_bin_text(x, greater = 'Above', middle = '', equal = '', less = 'to')
f_bin_text(z, greater = 'From', middle = '', equal = '', less = 'up to')

f_bin_text_right(x)
f_bin_text_right(y)
f_bin_text_right(cut(-4:10, c(-3, 2, 6, 11)))
f_bin_text_right(x, equal.digits = TRUE)

f_bin_right(x)
f_bin_right(y)
f_bin_right(x, equal.digits = TRUE)
## HTML
f_bin_right(y, le = '&le;')

\dontrun{
library(tidyverse)

mtcars \%>\%
    mutate(mpg2 = cut(mpg, 3)) \%>\%
    ggplot(aes(disp, hp)) +
        geom_point() +
        facet_wrap(~ mpg2,
            labeller = ff_bin()
        )

mtcars \%>\%
    mutate(mpg2 = cut(mpg, 3)) \%>\%
    ggplot(aes(disp, hp)) +
        geom_point() +
        facet_wrap(~ mpg2,
            labeller = function(x) f_bin_right(x, parse = TRUE)
        )

mtcars \%>\%
    mutate(mpg2 = cut(mpg, 3, right = FALSE)) \%>\%
    ggplot(aes(disp, hp)) +
        geom_point() +
        facet_wrap(~ mpg2,
            labeller = function(x) f_bin_right(x, parse = TRUE)
        )

mtcars \%>\%
    mutate(mpg2 = cut(mpg, 5, right = FALSE)) \%>\%
    ggplot(aes(mpg2)) +
        geom_bar() +
        scale_x_discrete(labels = ff_bin_text_right(l = 'Up to')) +
        coord_flip()

mtcars \%>\%
    mutate(mpg2 = cut(mpg, 10, right = FALSE)) \%>\%
    ggplot(aes(mpg2)) +
        geom_bar(fill = '#33A1DE') +
        scale_x_discrete(labels = function(x) f_wrap(f_bin_text_right(x, l = 'up to'), width = 8)) +
        scale_y_continuous(breaks = seq(0, 14, by = 2), limits = c(0, 7)) +
        theme_minimal() +
        theme(
            panel.grid.major.x = element_blank(),
            axis.text.x = element_text(size = 14, margin = margin(t = -12)),
            axis.text.y = element_text(size = 14),
            plot.title = element_text(hjust = .5)
        ) +
        labs(title = 'Histogram', x = NULL, y = NULL)
}
}
