% Generated by roxygen2 (4.0.2): do not edit by hand
\name{null_lm}
\alias{null_lm}
\title{Generate null data with null residuals from a model.}
\usage{
null_lm(f, method = "rotate", ...)
}
\arguments{
\item{f}{model specification formula, as defined by \code{\link{lm}}}

\item{method}{method for generating null residuals.  Built in methods
'rotate', 'pboot' and 'boot' are defined by \code{\link{resid_rotate}},
\code{\link{resid_pboot}} and \code{\link{resid_boot}} respectively}

\item{...}{other arguments passedd onto \code{method}.}
}
\value{
a function that given \code{data} generates a null data set.
  For use with \code{\link{lineup}} or \code{\link{rorschach}}
}
\description{
Null hypothesis: variable is linear combination of predictors
}
\examples{
if (requireNamespace('reshape2', quietly = TRUE)) {
data("tips", package = "reshape2")
x <- lm(tip ~ total_bill, data = tips)
tips.reg <- data.frame(tips, .resid = residuals(x), .fitted = fitted(x))
qplot(total_bill, .resid, data = tips.reg) \%+\%
  lineup(null_lm(tip ~ total_bill, method = 'rotate'), tips.reg) +
  facet_wrap(~ .sample)
}
}

