% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsPois.R
\name{Neutrosophic Poisson}
\alias{Neutrosophic Poisson}
\alias{dnsPois}
\alias{pnsPois}
\alias{qnsPois}
\alias{rnsPois}
\title{Neutrosophic Poisson Distribution}
\usage{
dnsPois(x, lambda)

pnsPois(q, lambda, lower.tail = TRUE)

qnsPois(p, lambda)

rnsPois(n, lambda)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{lambda}{the mean, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsPois} gives the probability mass function

 \code{pnsPois} gives the distribution function

 \code{qnsPois} gives the quantile function

 \code{rnsPois} generates random variables from the neutrosophic Poisson Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Poisson distribution with
parameter \eqn{\lambda_N}.
}
\details{
The neutrosophic Poisson distribution with parameter \eqn{\lambda_N}
has the density
\deqn{f_N(x)= \exp\{-\lambda_N\}  \frac{\left(\lambda_N\right)^x}{x !}}
for \eqn{\lambda_N \in (\lambda_L, \lambda_U)} which must be a positive
interval and \eqn{x \in \{0, 1, 2, \ldots\}}.
}
\examples{
# In a company, Phone employee receives phone calls, the calls arrive with
# rate of [1 , 3] calls per minute, we will calculate
# the probability that the employee will not receive any call within a minute
dnsPois(x = 0, lambda = c(1, 3))

# the probability that employee would not receive any call within 5 minutes
dnsPois(x = 0, lambda = c(5, 15))
# the probability that the employee will receive at least one call within a minute
pnsPois(q = 1, lambda = c(1, 3), lower.tail = FALSE)
# the probability that the employee will receive at most three calls within 5 minutes
pnsPois(q = 3, lambda = c(5, 15), lower.tail = TRUE)
# Calcaute the quantiles
qnsPois(p = c(0.25, 0.5, 0.75), lambda = c(1, 3))
# Simulate 10 values
rnsPois(n = 10, lambda = 1)
}
\references{
Alhabib, R., Ranna, M. M., Farah, H., Salama, A. A. (2018).
       Some neutrosophic probability distributions.
       \emph{Neutrosophic Sets and Systems},  22, 30-38.
}
