% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsGamma.R
\name{Neutrosophic Gamma}
\alias{Neutrosophic Gamma}
\alias{dnsGamma}
\alias{pnsGamma}
\alias{qnsGamma}
\alias{rnsGamma}
\title{Neutrosophic Gamma Distribution}
\usage{
dnsGamma(x, shape, scale)

pnsGamma(q, shape, scale, lower.tail = TRUE)

qnsGamma(p, shape, scale)

rnsGamma(n, shape, scale)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape}{the shape parameter, which must be a positive interval.}

\item{scale}{the scale parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{dnsGamma} gives the density function

 \code{pnsGamma} gives the distribution function

 \code{qnsGamma} gives the quantile function

 \code{rnsGamma} generates random variables from the neutrosophic gamma distribution.
}
\description{
Density, distribution function, quantile function and random generation for
the neutrosophic gamma distribution with parameter \code{shape} = \eqn{\alpha_N}
and \code{scale}=\eqn{\lambda_N}.
}
\details{
The neutrosophic gamma distribution with parameters \eqn{\alpha_N} and
\eqn{\lambda_N} has density
\deqn{f_N(x)=\frac{1}{\Gamma(\alpha_N) \lambda_N^{\alpha_N}} x^{\alpha_N-1} \exp\{-\left(x / \lambda_N\right)\}}
for \eqn{x \ge 0}, \eqn{\alpha_N \in (\alpha_L, \alpha_U)}, the shape
parameter which must be a positive interval and
\eqn{\lambda_N \in (\lambda_L, \lambda_U)}, the scale parameter which
must be a positive interval. Here, \eqn{\Gamma(\cdot)} is gamma
function implemented by \code{\link{gamma}}.
}
\examples{
data(remission)
dnsGamma(x = remission, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

pnsGamma(q = 20, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Calculate quantiles
qnsGamma(p = c(0.25, 0.5, 0.75), shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Simulate 10 numbers
rnsGamma(n = 10, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))
}
\references{
Khan, Z., Al-Bossly, A., Almazah, M. M. A., and Alduais, F. S. (2021).
   On statistical development of neutrosophic gamma distribution with
   applications to complex data analysis, \emph{Complexity}, 2021, Article ID 3701236.
}
