% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgamma.R
\name{Neutrosophic Gamma}
\alias{Neutrosophic Gamma}
\alias{dnsgamma}
\alias{pnsgamma}
\alias{qnsgamma}
\alias{rnsgamma}
\title{Neutrosophic Gamma Distribution}
\usage{
dnsgamma(x, shape, scale)

pnsgamma(q, shape, scale, lower.tail = TRUE)

qnsgamma(p, shape, scale)

rnsgamma(n, shape, scale)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape}{the shape parameter, which must be a positive interval.}

\item{scale}{the scale parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsgamma} gives the distribution function,
 \code{dnsgamma} gives the density,
 \code{qnsgamma} gives the quantile function and
 \code{rnsgamma} generates random variables from the neutrosophic gamma distribution.
}
\description{
Density, distribution function, quantile function and random generation for
the neutrosophic gamma distribution with parameter \code{shape} = \eqn{\alpha_N}
and \code{scale}=\eqn{\lambda_N}.
}
\details{
The neutrosophic gamma distribution with parameters \eqn{\alpha_N} and
\eqn{\lambda_N} has density
\deqn{f_n(x)=\frac{1}{\Gamma(\alpha_n) \lambda_n^{\alpha_n}} x^{\alpha_n-1} \exp\{-\left(x / \lambda_n\right)\}}
for \eqn{x \ge 0}, \eqn{\alpha_N \in (\alpha_L, \alpha_U)}, the shape
parameter which must be a positive interval and
\eqn{\lambda_n \in (\lambda_L, \lambda_U)}, the scale parameter which
must be a positive interval. Here, \eqn{\Gamma(\cdot)} is gamma
function implemented by \code{\link{gamma}}.
}
\examples{
data(remission)
dnsgamma(x = remission, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

pnsgamma(q = 20, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Calculate quantiles
qnsgamma(p = c(0.25, 0.5, 0.75), shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))

# Simulate 10 numbers
rnsgamma(n = 10, shape = c(1.1884, 1.1896), scale = c(7.6658, 7.7796))
}
\references{
Khan, Z., Al-Bossly, A., Almazah, M. M. A., and Alduais, F. S. (2021).
   On statistical development of neutrosophic gamma distribution with
   applications to complex data analysis, \emph{Complexity}, 2021, Article ID 3701236.
}
