% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nseopen.R
\name{nseopen}
\alias{nseopen}
\title{NSE Pre Open Market}
\source{
<https://www1.nseindia.com/live_market/dynaContent/live_watch/pre_open_market/pre_open_market.htm>
}
\usage{
nseopen(x = "n50")
}
\arguments{
\item{x}{"fo" for F&O stocks, "all" for all the stocks. Default is "n50" for NIFTY 50 stocks.}
}
\value{
A dataframe with NSE Pre open market data.
}
\description{
NSE Pre Open Market
}
\details{
Get NSE Pre open market data.
}
\note{
NSE market opening time is 9.00 AM (IST). The NSE pre market closes at 9.08 AM (IST).
}
\examples{
\dontrun{
# NSE Pre market open data of Nifty 50 stocks
library(nser)
nseopen("n50")

# Pre market for F&O stocks
nseopen("fo")
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhav}}\code{\link[nser]{fobhavtoday}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
