% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-involvement-survey.R
\docType{data}
\name{involvement_survey_pop}
\alias{involvement_survey_pop}
\title{Parent involvement survey: population data}
\format{
A data frame with 20,000 rows and 9 variables
}
\usage{
involvement_survey_pop
}
\description{
An example dataset describing a population of 20,000 students with disabilities
in 20 school districts. This population is the basis for selecting a sample of
students for a parent involvement survey.
}
\section{Fields}{


\describe{
\item{UNIQUE_ID}{A unique identifier for students}
\item{SCHOOL_DISTRICT}{A unique identifier for school districts}
\item{SCHOOL_ID}{A unique identifier for schools, nested within districts}
\item{STUDENT_GRADE}{Student's grade level: 'PK', 'K', 1-12}
\item{STUDENT_AGE}{Student's age, measured in years}
\item{STUDENT_DISABILITY_CODE}{Code for student's disability category (e.g. 'VI' for 'Visual Impairments')}
\item{STUDENT_DISABILITY_CATEGORY}{Student's disability category (e.g. 'Visual Impairments')}
\item{STUDENT_SEX}{'Female' or 'Male'}
\item{STUDENT_RACE}{Seven-level code with descriptive label (e.g. 'AS7 (Asian)')}
}
}

\examples{
involvement_survey_pop
}
\keyword{datasets}
