% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkParentAge.R
\name{checkParentAge}
\alias{checkParentAge}
\title{Check parent ages to be at least \code{minParentAge}}
\usage{
checkParentAge(sb, minParentAge = 2L, reportErrors = FALSE)
}
\arguments{
\item{sb}{A dataframe containing a table of pedigree and demographic
information.}

\item{minParentAge}{numeric values to set the minimum age in years for
an animal to have an offspring. Defaults to 2 years. The check is not
performed for animals with missing birth dates.}

\item{reportErrors}{logical value if TRUE will scan the entire file and
make a list of all errors found. The errors will be returned in a
list of list where each sublist is a type of error found.}
}
\value{
A dataframe containing rows for each animal where one or more
parent was less than \code{minParentAge}. It contains all of the columns
in the original \code{sb} dataframe with the following added columns:
\enumerate{
\item \{sireBirth\} \{sire's birth date\}
\item\{sireAge\} \{age of sire in years on the date indicated by
\code{birth}.\}
\item\{damBirth\} \{dam's birth date\}
\code{damAge} \{age of dam in years on the date indicated by \code{birth}.\}
}
}
\description{
Ensure parents are sufficiently older than offspring
}
\examples{
library(nprcgenekeepr)
qcPed <- nprcgenekeepr::qcPed
checkParentAge(qcPed, minParentAge = 2L)
checkParentAge(qcPed, minParentAge = 3L)
checkParentAge(qcPed, minParentAge = 5L)
checkParentAge(qcPed, minParentAge = 6L)
head(checkParentAge(qcPed, minParentAge = 10L))
}
