\name{plot.glmmNPML}
\alias{plot.glmmNPML}
\alias{plot.glmmGQ}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Plot Diagnostics for objects of class glmmNPML or glmmGQ}
\description{
  The functions \code{alldist}  and \code{allvc}   produce  
  objects of type \code{glmmGQ}, if Gaussian quadrature (Hinde, 1982, 
  \code{random.distribution="gq"}) was applied for computation, and  objects
   of class \code{glmmNPML}, if parameter estimation was carried out by nonparametric
    maximum likelihood (Aitkin, 1996a, \code{random.distribution="np"}). 
    The functions presented here give some useful diagnostic plotting functionalities 
    to analyze these objects. 
}
\usage{
plot.glmmNPML(x, plot.opt = 15, noformat=FALSE, ...)
plot.glmmGQ(x, plot.opt = 3, noformat=FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a fitted object of class \code{glmmNPML} or \code{glmmGQ}.   }
  \item{plot.opt}{an integer with values \eqn{0 \le}{0 <=} \code{plot.opt} \eqn{\le 15}{<=15}. }
  \item{noformat}{if \code{TRUE}, then any formatting of the plots is omitted (useful if the user wants to include the plots into a panel of several other plots, possibly generated by other functions).}
  \item{\dots}{further arguments which will mostly not have any effect 
    (and are included only to ensure compatibility with the 
    generic \code{plot()}- function.)  }
}
\details{
  See the help pages to alldist and the vignette (Einbeck & Hinde, 2006). 
  It is sufficient to write \code{plot} instead of \code{plot.glmmNPML} or \code{plot.glmmGQ},
   since the generic \code{plot} function provided in \R automatically selects the right model class. 
}
\value{
  For class \code{glmmNPML}: Depending on the choice of \code{plot.opt}, a subset
  of the following four plots:


\item{1}{Disparity trend.}
\item{2}{EM Trajectories.}
\item{3}{Empirical Bayes Predictions against observed response.}
\item{4}{Individual posterior probabilities.}

The number given in \code{plot.opt} is transformed into a binary
number indicating which plots are to be selected. The first digit
(from the right!) refers to plot 1, the second one to plot 2, and so on.
For example, \code{plot.opt=4} gives the binary number 0100 and hence selects
just plot 3.

For class \code{glmmGQ}: Depending on the choice of plot.opt,
a subset of  plots  1 and 3. Again, the number is transformed into binary coding, yielding only the
disparity trend for \code{plot.opt=1}, only the EBP's for \code{plot.opt=2},
and both plots for \code{plot.opt=3}.
 }

\references{
Aitkin, M. (1996a). A general maximum likelihood analysis of overdispersion in generalized linear models. Statistics and Computing 6, 251-262. 

Einbeck, J., and Hinde, J. (2006). Nonparametric maximum likelihood estimation for random effect models in R. Vignette to R package  \pkg{npmlreg}. 
Type \code{vignette("npmlreg-v")} to open it.

Hinde, J. (1982). Compound Poisson regression models. Lecture Notes in Statistics 14, 109-121. 
}


 }
\author{ Jochen Einbeck and John Hinde (2006) }
\seealso{ 
\code{\link{alldist}}, \code{\link{allvc}}  
}
\examples{

data(galaxies, package="MASS")
gal<-as.data.frame(galaxies)
galaxy.np4u <- alldist(galaxies/1000~1,random=~1,k=4,tol=0.5,data=gal,lambda=1)
predict(galaxy.np4u, type="response") # EBP on scale of responses

plot(galaxy.np4u,  plot.opt=4) # plots only EBP vs.  response
plot(galaxy.np4u,  plot.opt=3) # gives same output as given by default when executing alldist
plot(galaxy.np4u)              # gives all four plots.
}
\keyword{ models }% at least one, from doc/KEYWORDS
\keyword{ regression }% __ONLY ONE__ keyword per line
