% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_functions.R
\name{plot_diagram}
\alias{plot_diagram}
\title{Draw a state space figure}
\usage{
plot_diagram(A, B, A_subgr_labels = "", B_subgr_labels = "",
  which = c("Both", "Experimental", "Control"),
  treatment_labels = c("Experimental", "Control"), colors = "default",
  show.rate = TRUE)
}
\arguments{
\item{A}{An object of class \code{mixpch}, resembling the survival function in treatment group 0}

\item{B}{An object of class \code{mixpch}, resembling the survival function in treatment group 1}

\item{A_subgr_labels}{A character vector with the same length as A$p. It indicates names for the subgroups in A}

\item{B_subgr_labels}{A character vector with the same length as B$p. It indicates names for the subgroups in B}

\item{which}{Which treatment arm should be shown? One of "Both", "Experimental", "Control".}

\item{treatment_labels}{A character vector of length 2 indicating the treatment labels.}

\item{colors}{Either a vector of length two with colors for A and B, or "default".}

\item{show.rate}{A logical indicating whether the rate should be shown in the diagram}
}
\description{
A figure that shows the states and the possible transitions between them.
}
