% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRTDB.R
\name{PRTDB}
\alias{PRTDB}
\title{Pseudo Real Time Data Base}
\usage{
PRTDB(mts, delay, vintage = Sys.Date())
}
\arguments{
\item{mts}{A \code{mts} with the series data.}

\item{delay}{A numeric vector with the delay in days the information is available after the reference month. Each element corresponds to the series in the respective column in \code{mts}.}

\item{vintage}{The day when the data is supposed to be collected.}
}
\value{
A \code{mts} with the series transformed.
}
\description{
Create a pseudo real time data base based on data and delays of disclosure stipulated by the user.
}
\examples{
# Pseudo Real Time Data Base from data base BRGDP
PRTDB(mts = BRGDP$base, delay = BRGDP$delay, vintage = "2017-10-01")
}
