% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{modelpath.character}
\alias{modelpath.character}
\title{Resolve A Path to a Model-related File for Character}
\usage{
\method{modelpath}{character}(
  x,
  ext = NULL,
  project = getOption("project", getwd()),
  nested = getOption("nested", TRUE),
  ...
)
}
\arguments{
\item{x}{object}

\item{ext}{file extension, no leading dot}

\item{project}{project directory}

\item{nested}{whether model files are nested in eponymous directories}

\item{...}{passed arguments}
}
\value{
character
}
\description{
Resolves a path to a model-related file, treating \code{x} as a model name.
By default (\code{ext} is NULL) the run directory is returned.
As of version 0.9.2, \code{nested} can be a function of \code{ext} and \dots
That returns logical.
}
\seealso{
Other path: 
\code{\link{datafile.character}()},
\code{\link{datafile.numeric}()},
\code{\link{datafile}()},
\code{\link{modeldir}()},
\code{\link{modelfile}()},
\code{\link{modelpath.numeric}()},
\code{\link{modelpath}()},
\code{\link{psn_options}()},
\code{\link{specfile.character}()},
\code{\link{specfile.numeric}()},
\code{\link{specfile}()}
}
\concept{path}
