% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogate.data.R
\name{surrogateTest}
\alias{surrogateTest}
\title{Surrogate data testing}
\usage{
surrogateTest(
  time.series,
  significance = 0.05,
  one.sided = FALSE,
  alternative = c("smaller", "larger"),
  K = 1,
  FUN,
  verbose = TRUE,
  do.plot = TRUE,
  xlab = "Values of the statistic",
  ylab = "",
  main = "Surrogate data testing",
  ...
)
}
\arguments{
\item{time.series}{The original time.series from which the surrogate data is
generated.}

\item{significance}{Significance of the test}

\item{one.sided}{Logical value. If \emph{TRUE}, the routine runs a one-side
test. If \emph{FALSE}, a two-side test is applied (default).}

\item{alternative}{Specifies the concrete type of one-side test that should be 
performed: If the the user wants to test if the statistic from the original
data is smaller (\emph{alternative="smaller"}) or larger 
(\emph{alternative="larger"}) than the expected value under the
 null hypothesis.}

\item{K}{Integer controlling the number of surrogates to be generated (see
details).}

\item{FUN}{The function that computes the discriminating statistic that shall
be used for testing.}

\item{verbose}{Logical value. If TRUE, a brief summary of the test is shown.}

\item{do.plot}{Logical value. If TRUE, a graphical representation of the 
statistic value for  both surrogates and original data is shown.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{main}{an overall title for the plot.}

\item{...}{Additional arguments for the FUN function.}
}
\value{
A list containing the values of the statistic for the surrogates 
(\emph{surrogates.statistics} field) and the value for the original time 
series (\emph{data.statistic})
}
\description{
Surrogate data testing
}
\details{
This function tests the null hypothesis (H0) stating that the series 
is a gaussian linear process. The test is performed by generating several 
surrogate data according to H0 and comparing the values of a discriminating
statistic between both original data and the surrogate data. If the value of 
the statistic is significantly different for the original series than for the
surrogate set, the null hypothesis is rejected and nonlinearity assumed.  

To test with a significance level of \eqn{\alpha}{alpha} if the statistic
from the original data is smaller than the expected  value under the null
hypothesis (a one-side test),  \eqn{K/\alpha - 1}{K/alpha - 1} surrogates
are generated. The null hypothesis is then rejected if the statistic from
 the data has one of the K smallest values. For a two-sided test, 
\eqn{2K/\alpha - 1}{2K/alpha - 1} surrogates are generated. The null 
hypothesis is rejected if the statistic from the data gives one of the K 
smallest or largest values.

The  surrogate data is generated by using a phase randomization procedure.
}
\examples{
\dontrun{
 lx = lorenz(do.plot=F)$x 
 sdt = surrogateTest(time.series = lx,significance = 0.05,
                     K=5, one.sided = FALSE, FUN=timeAsymmetry) 
}
}
\references{
SCHREIBER, Thomas; SCHMITZ, Andreas. Surrogate time series. 
Physica D: Nonlinear Phenomena, 2000, vol. 142, no 3, p. 346-382.
}
\author{
Constantino A. Garcia
}
