% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dend.plot.R
\name{dend.plot}
\alias{dend.plot}
\title{Visualization of Cluster Hierarchy using a Dendrogram}
\usage{
dend.plot(
  x,
  clusters = "BIC",
  style = "greys",
  colorful = TRUE,
  clu.col = NA,
  main = "Dendrogram",
  ac = TRUE,
  ...
)
}
\arguments{
\item{x}{An output of the \code{nomclust()} or \code{nomprox()} functions containing the \code{dend} component.}

\item{clusters}{Either a numeric value or a character string with the name of the evaluation criterion expressing the number of displayed clusters in a dendrogram. The following evaluation criteria can be used: \code{"AIC"}, \code{"BIC"}, \code{"BK"}, \code{"PSFE"}, \code{"PSFM"}, and \code{"SI"}.}

\item{style}{A character string or a vector of colors defines the graphical style of the produced plots. There are two predefined styles in the \bold{nomclust} package, namely \code{"greys"} and \code{"dark"}, but a custom color scheme can be set by a user as a vector of a length four.}

\item{colorful}{A logical argument that is specifying if the output will be colorful or black and white.}

\item{clu.col}{An optional vector of colors that allows a researcher to apply user-defined colors for displayed (marked) clusters in a dendrogram.}

\item{main}{A character string with the chart title.}

\item{ac}{A logical argument that indicates if an agglomerative coefficient will be present in the output.}

\item{...}{Other graphical arguments compatible with the generic \code{plot()} function.}
}
\value{
The function returns a dendrogram describing the hierarchy of clusters that can help to identify the optimal number of clusters.
\cr
}
\description{
The function visualizes the hierarchy of clusters using a dendrogram. The function also enables a user to distinguish the individual clusters with colors. 
The number of displayed clusters can be defined by a user or by one of the six evaluation criteria.
}
\details{
The function can be applied to a \code{nomclust()} or \code{nomprox()} output containing the \code{dend} component.
}
\examples{
# sample data
data(data20)

# creating an object with results of hierarchical clustering 
hca.object <- nomclust(data20, measure = "iof", eval = TRUE)

# a basic plot
dend.plot(hca.object)

# a dendrogram with color-coded clusters according to the BIC index
dend.plot(hca.object, clusters = "BIC", colorful = TRUE)

# using a dark style and specifying own colors in a solution with three clusters
dend.plot(hca.object, clusters = 3, style = "dark", clu.col = c("blue", "red", "green"))

# a black and white dendrogram
dend.plot(hca.object, clusters = 3, style = "dark", colorful = FALSE)

}
\seealso{
\code{\link[nomclust]{eval.plot}}, \code{\link[nomclust]{nomclust}}, \code{\link[nomclust]{nomprox}}.
}
\author{
Jana Cibulkova and Zdenek Sulc. \cr Contact: \email{jana.cibulkova@vse.cz}
}
